package physx.particles;

public enum PxParticleSolverTypeEnum {

    ePBD(getePBD()),
    eFLIP(geteFLIP()),
    eMPM(geteMPM());
    public final int value;
    
    PxParticleSolverTypeEnum(int value) {
        this.value = value;
    }

    private static native int _getePBD();
    private static int getePBD() {
        de.fabmax.physxjni.Loader.load();
        physx.PlatformChecks.requirePlatform(3, "physx.particles.PxParticleSolverTypeEnum");
        return _getePBD();
    }

    private static native int _geteFLIP();
    private static int geteFLIP() {
        de.fabmax.physxjni.Loader.load();
        physx.PlatformChecks.requirePlatform(3, "physx.particles.PxParticleSolverTypeEnum");
        return _geteFLIP();
    }

    private static native int _geteMPM();
    private static int geteMPM() {
        de.fabmax.physxjni.Loader.load();
        physx.PlatformChecks.requirePlatform(3, "physx.particles.PxParticleSolverTypeEnum");
        return _geteMPM();
    }

    public static PxParticleSolverTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxParticleSolverTypeEnum: " + value);
    }

}
