package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;

public class PxParticleSpring extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleSpring");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleSpring wrapPointer(long address) {
        return address != 0L ? new PxParticleSpring(address) : null;
    }
    
    public static PxParticleSpring arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleSpring(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxParticleSpring
     */
    public static PxParticleSpring createAt(long address) {
        __placement_new_PxParticleSpring(address);
        PxParticleSpring createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxParticleSpring
     */
    public static <T> PxParticleSpring createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxParticleSpring(address);
        PxParticleSpring createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxParticleSpring(long address);

    // Constructors

    public PxParticleSpring() {
        address = _PxParticleSpring();
    }
    private static native long _PxParticleSpring();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getInd0() {
        checkNotNull();
        return _getInd0(address);
    }
    private static native int _getInd0(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setInd0(int value) {
        checkNotNull();
        _setInd0(address, value);
    }
    private static native void _setInd0(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getInd1() {
        checkNotNull();
        return _getInd1(address);
    }
    private static native int _getInd1(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setInd1(int value) {
        checkNotNull();
        _setInd1(address, value);
    }
    private static native void _setInd1(long address, int value);

    /**
     * @return WebIDL type: float
     */
    public float getLength() {
        checkNotNull();
        return _getLength(address);
    }
    private static native float _getLength(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setLength(float value) {
        checkNotNull();
        _setLength(address, value);
    }
    private static native void _setLength(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getStiffness() {
        checkNotNull();
        return _getStiffness(address);
    }
    private static native float _getStiffness(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setStiffness(float value) {
        checkNotNull();
        _setStiffness(address, value);
    }
    private static native void _setStiffness(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getDamping() {
        checkNotNull();
        return _getDamping(address);
    }
    private static native float _getDamping(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setDamping(float value) {
        checkNotNull();
        _setDamping(address, value);
    }
    private static native void _setDamping(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getPad() {
        checkNotNull();
        return _getPad(address);
    }
    private static native float _getPad(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setPad(float value) {
        checkNotNull();
        _setPad(address, value);
    }
    private static native void _setPad(long address, float value);

}
