package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.CUstream;

public class PxParticleSystemCallback extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleSystemCallback");
    }

    protected PxParticleSystemCallback() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleSystemCallback wrapPointer(long address) {
        return address != 0L ? new PxParticleSystemCallback(address) : null;
    }
    
    public static PxParticleSystemCallback arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleSystemCallback(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param gpuParticleSystem WebIDL type: {@link PxGpuMirroredGpuParticleSystemPointer} [Const, Ref]
     * @param stream            WebIDL type: {@link CUstream} [Value]
     */
    public void onBegin(PxGpuMirroredGpuParticleSystemPointer gpuParticleSystem, CUstream stream) {
        checkNotNull();
        _onBegin(address, gpuParticleSystem.getAddress(), stream.getAddress());
    }
    private static native void _onBegin(long address, long gpuParticleSystem, long stream);

    /**
     * @param gpuParticleSystem WebIDL type: {@link PxGpuMirroredGpuParticleSystemPointer} [Const, Ref]
     * @param stream            WebIDL type: {@link CUstream} [Value]
     */
    public void onAdvance(PxGpuMirroredGpuParticleSystemPointer gpuParticleSystem, CUstream stream) {
        checkNotNull();
        _onAdvance(address, gpuParticleSystem.getAddress(), stream.getAddress());
    }
    private static native void _onAdvance(long address, long gpuParticleSystem, long stream);

    /**
     * @param gpuParticleSystem WebIDL type: {@link PxGpuMirroredGpuParticleSystemPointer} [Const, Ref]
     * @param stream            WebIDL type: {@link CUstream} [Value]
     */
    public void onPostSolve(PxGpuMirroredGpuParticleSystemPointer gpuParticleSystem, CUstream stream) {
        checkNotNull();
        _onPostSolve(address, gpuParticleSystem.getAddress(), stream.getAddress());
    }
    private static native void _onPostSolve(long address, long gpuParticleSystem, long stream);

}
