package physx.physics;

import physx.common.PxBase;
import physx.geometry.PxBVH;

public class PxAggregate extends PxBase {

    protected PxAggregate() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxAggregate wrapPointer(long address) {
        return address != 0L ? new PxAggregate(address) : null;
    }
    
    public static PxAggregate arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxAggregate(long address) {
        super(address);
    }

    // Functions

    /**
     * @param actor WebIDL type: {@link PxActor} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean addActor(PxActor actor) {
        checkNotNull();
        return _addActor(address, actor.getAddress());
    }
    private static native boolean _addActor(long address, long actor);

    /**
     * @param actor WebIDL type: {@link PxActor} [Ref]
     * @param bvh   WebIDL type: {@link PxBVH} [Const]
     * @return WebIDL type: boolean
     */
    public boolean addActor(PxActor actor, PxBVH bvh) {
        checkNotNull();
        return _addActor(address, actor.getAddress(), bvh.getAddress());
    }
    private static native boolean _addActor(long address, long actor, long bvh);

    /**
     * @param actor WebIDL type: {@link PxActor} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean removeActor(PxActor actor) {
        checkNotNull();
        return _removeActor(address, actor.getAddress());
    }
    private static native boolean _removeActor(long address, long actor);

    /**
     * @param articulation WebIDL type: {@link PxArticulationReducedCoordinate} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean addArticulation(PxArticulationReducedCoordinate articulation) {
        checkNotNull();
        return _addArticulation(address, articulation.getAddress());
    }
    private static native boolean _addArticulation(long address, long articulation);

    /**
     * @param articulation WebIDL type: {@link PxArticulationReducedCoordinate} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean removeArticulation(PxArticulationReducedCoordinate articulation) {
        checkNotNull();
        return _removeArticulation(address, articulation.getAddress());
    }
    private static native boolean _removeArticulation(long address, long articulation);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbActors() {
        checkNotNull();
        return _getNbActors(address);
    }
    private static native int _getNbActors(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbActors() {
        checkNotNull();
        return _getMaxNbActors(address);
    }
    private static native int _getMaxNbActors(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbShapes() {
        checkNotNull();
        return _getMaxNbShapes(address);
    }
    private static native int _getMaxNbShapes(long address);

    /**
     * @return WebIDL type: {@link PxScene}
     */
    public PxScene getScene() {
        checkNotNull();
        return PxScene.wrapPointer(_getScene(address));
    }
    private static native long _getScene(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getSelfCollision() {
        checkNotNull();
        return _getSelfCollision(address);
    }
    private static native boolean _getSelfCollision(long address);

}
