package physx.physics;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxArticulationAttachment extends NativeObject {

    protected PxArticulationAttachment() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArticulationAttachment wrapPointer(long address) {
        return address != 0L ? new PxArticulationAttachment(address) : null;
    }
    
    public static PxArticulationAttachment arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArticulationAttachment(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getUserData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getUserData(address));
    }
    private static native long _getUserData(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setUserData(NativeObject value) {
        checkNotNull();
        _setUserData(address, value.getAddress());
    }
    private static native void _setUserData(long address, long value);

    // Functions

    /**
     * @param restLength WebIDL type: float
     */
    public void setRestLength(float restLength) {
        checkNotNull();
        _setRestLength(address, restLength);
    }
    private static native void _setRestLength(long address, float restLength);

    /**
     * @return WebIDL type: float
     */
    public float getRestLength() {
        checkNotNull();
        return _getRestLength(address);
    }
    private static native float _getRestLength(long address);

    /**
     * @param parameters WebIDL type: {@link PxArticulationTendonLimit} [Const, Ref]
     */
    public void setLimitParameters(PxArticulationTendonLimit parameters) {
        checkNotNull();
        _setLimitParameters(address, parameters.getAddress());
    }
    private static native void _setLimitParameters(long address, long parameters);

    /**
     * @return WebIDL type: {@link PxArticulationTendonLimit} [Value]
     */
    public PxArticulationTendonLimit getLimitParameters() {
        checkNotNull();
        return PxArticulationTendonLimit.wrapPointer(_getLimitParameters(address));
    }
    private static native long _getLimitParameters(long address);

    /**
     * @param offset WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setRelativeOffset(PxVec3 offset) {
        checkNotNull();
        _setRelativeOffset(address, offset.getAddress());
    }
    private static native void _setRelativeOffset(long address, long offset);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getRelativeOffset() {
        checkNotNull();
        return PxVec3.wrapPointer(_getRelativeOffset(address));
    }
    private static native long _getRelativeOffset(long address);

    /**
     * @param coefficient WebIDL type: float
     */
    public void setCoefficient(float coefficient) {
        checkNotNull();
        _setCoefficient(address, coefficient);
    }
    private static native void _setCoefficient(long address, float coefficient);

    /**
     * @return WebIDL type: float
     */
    public float getCoefficient() {
        checkNotNull();
        return _getCoefficient(address);
    }
    private static native float _getCoefficient(long address);

    /**
     * @return WebIDL type: {@link PxArticulationLink}
     */
    public PxArticulationLink getLink() {
        checkNotNull();
        return PxArticulationLink.wrapPointer(_getLink(address));
    }
    private static native long _getLink(long address);

    /**
     * @return WebIDL type: {@link PxArticulationAttachment}
     */
    public PxArticulationAttachment getParent() {
        checkNotNull();
        return PxArticulationAttachment.wrapPointer(_getParent(address));
    }
    private static native long _getParent(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isLeaf() {
        checkNotNull();
        return _isLeaf(address);
    }
    private static native boolean _isLeaf(long address);

    /**
     * @return WebIDL type: {@link PxArticulationSpatialTendon}
     */
    public PxArticulationSpatialTendon getTendon() {
        checkNotNull();
        return PxArticulationSpatialTendon.wrapPointer(_getTendon(address));
    }
    private static native long _getTendon(long address);

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

}
