package physx.physics;

import physx.NativeObject;
import physx.support.PxRealPtr;

public class PxArticulationCache extends NativeObject {

    protected PxArticulationCache() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArticulationCache wrapPointer(long address) {
        return address != 0L ? new PxArticulationCache(address) : null;
    }
    
    public static PxArticulationCache arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArticulationCache(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxSpatialForce}
     */
    public PxSpatialForce getExternalForces() {
        checkNotNull();
        return PxSpatialForce.wrapPointer(_getExternalForces(address));
    }
    private static native long _getExternalForces(long address);

    /**
     * @param value WebIDL type: {@link PxSpatialForce}
     */
    public void setExternalForces(PxSpatialForce value) {
        checkNotNull();
        _setExternalForces(address, value.getAddress());
    }
    private static native void _setExternalForces(long address, long value);

    /**
     * @return WebIDL type: {@link PxRealPtr} [Value]
     */
    public PxRealPtr getDenseJacobian() {
        checkNotNull();
        return PxRealPtr.wrapPointer(_getDenseJacobian(address));
    }
    private static native long _getDenseJacobian(long address);

    /**
     * @param value WebIDL type: {@link PxRealPtr} [Value]
     */
    public void setDenseJacobian(PxRealPtr value) {
        checkNotNull();
        _setDenseJacobian(address, value.getAddress());
    }
    private static native void _setDenseJacobian(long address, long value);

    /**
     * @return WebIDL type: {@link PxRealPtr} [Value]
     */
    public PxRealPtr getMassMatrix() {
        checkNotNull();
        return PxRealPtr.wrapPointer(_getMassMatrix(address));
    }
    private static native long _getMassMatrix(long address);

    /**
     * @param value WebIDL type: {@link PxRealPtr} [Value]
     */
    public void setMassMatrix(PxRealPtr value) {
        checkNotNull();
        _setMassMatrix(address, value.getAddress());
    }
    private static native void _setMassMatrix(long address, long value);

    /**
     * @return WebIDL type: {@link PxRealPtr} [Value]
     */
    public PxRealPtr getJointVelocity() {
        checkNotNull();
        return PxRealPtr.wrapPointer(_getJointVelocity(address));
    }
    private static native long _getJointVelocity(long address);

    /**
     * @param value WebIDL type: {@link PxRealPtr} [Value]
     */
    public void setJointVelocity(PxRealPtr value) {
        checkNotNull();
        _setJointVelocity(address, value.getAddress());
    }
    private static native void _setJointVelocity(long address, long value);

    /**
     * @return WebIDL type: {@link PxRealPtr} [Value]
     */
    public PxRealPtr getJointAcceleration() {
        checkNotNull();
        return PxRealPtr.wrapPointer(_getJointAcceleration(address));
    }
    private static native long _getJointAcceleration(long address);

    /**
     * @param value WebIDL type: {@link PxRealPtr} [Value]
     */
    public void setJointAcceleration(PxRealPtr value) {
        checkNotNull();
        _setJointAcceleration(address, value.getAddress());
    }
    private static native void _setJointAcceleration(long address, long value);

    /**
     * @return WebIDL type: {@link PxRealPtr} [Value]
     */
    public PxRealPtr getJointPosition() {
        checkNotNull();
        return PxRealPtr.wrapPointer(_getJointPosition(address));
    }
    private static native long _getJointPosition(long address);

    /**
     * @param value WebIDL type: {@link PxRealPtr} [Value]
     */
    public void setJointPosition(PxRealPtr value) {
        checkNotNull();
        _setJointPosition(address, value.getAddress());
    }
    private static native void _setJointPosition(long address, long value);

    /**
     * @return WebIDL type: {@link PxRealPtr} [Value]
     */
    public PxRealPtr getJointForce() {
        checkNotNull();
        return PxRealPtr.wrapPointer(_getJointForce(address));
    }
    private static native long _getJointForce(long address);

    /**
     * @param value WebIDL type: {@link PxRealPtr} [Value]
     */
    public void setJointForce(PxRealPtr value) {
        checkNotNull();
        _setJointForce(address, value.getAddress());
    }
    private static native void _setJointForce(long address, long value);

    /**
     * @return WebIDL type: {@link PxSpatialVelocity}
     */
    public PxSpatialVelocity getLinkVelocity() {
        checkNotNull();
        return PxSpatialVelocity.wrapPointer(_getLinkVelocity(address));
    }
    private static native long _getLinkVelocity(long address);

    /**
     * @param value WebIDL type: {@link PxSpatialVelocity}
     */
    public void setLinkVelocity(PxSpatialVelocity value) {
        checkNotNull();
        _setLinkVelocity(address, value.getAddress());
    }
    private static native void _setLinkVelocity(long address, long value);

    /**
     * @return WebIDL type: {@link PxSpatialVelocity}
     */
    public PxSpatialVelocity getLinkAcceleration() {
        checkNotNull();
        return PxSpatialVelocity.wrapPointer(_getLinkAcceleration(address));
    }
    private static native long _getLinkAcceleration(long address);

    /**
     * @param value WebIDL type: {@link PxSpatialVelocity}
     */
    public void setLinkAcceleration(PxSpatialVelocity value) {
        checkNotNull();
        _setLinkAcceleration(address, value.getAddress());
    }
    private static native void _setLinkAcceleration(long address, long value);

    /**
     * @return WebIDL type: {@link PxArticulationRootLinkData}
     */
    public PxArticulationRootLinkData getRootLinkData() {
        checkNotNull();
        return PxArticulationRootLinkData.wrapPointer(_getRootLinkData(address));
    }
    private static native long _getRootLinkData(long address);

    /**
     * @param value WebIDL type: {@link PxArticulationRootLinkData}
     */
    public void setRootLinkData(PxArticulationRootLinkData value) {
        checkNotNull();
        _setRootLinkData(address, value.getAddress());
    }
    private static native void _setRootLinkData(long address, long value);

    /**
     * @return WebIDL type: {@link PxSpatialForce}
     */
    public PxSpatialForce getSensorForces() {
        checkNotNull();
        return PxSpatialForce.wrapPointer(_getSensorForces(address));
    }
    private static native long _getSensorForces(long address);

    /**
     * @param value WebIDL type: {@link PxSpatialForce}
     */
    public void setSensorForces(PxSpatialForce value) {
        checkNotNull();
        _setSensorForces(address, value.getAddress());
    }
    private static native void _setSensorForces(long address, long value);

    /**
     * @return WebIDL type: {@link PxRealPtr} [Value]
     */
    public PxRealPtr getCoefficientMatrix() {
        checkNotNull();
        return PxRealPtr.wrapPointer(_getCoefficientMatrix(address));
    }
    private static native long _getCoefficientMatrix(long address);

    /**
     * @param value WebIDL type: {@link PxRealPtr} [Value]
     */
    public void setCoefficientMatrix(PxRealPtr value) {
        checkNotNull();
        _setCoefficientMatrix(address, value.getAddress());
    }
    private static native void _setCoefficientMatrix(long address, long value);

    /**
     * @return WebIDL type: {@link PxRealPtr} [Value]
     */
    public PxRealPtr getLambda() {
        checkNotNull();
        return PxRealPtr.wrapPointer(_getLambda(address));
    }
    private static native long _getLambda(long address);

    /**
     * @param value WebIDL type: {@link PxRealPtr} [Value]
     */
    public void setLambda(PxRealPtr value) {
        checkNotNull();
        _setLambda(address, value.getAddress());
    }
    private static native void _setLambda(long address, long value);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getScratchMemory() {
        checkNotNull();
        return NativeObject.wrapPointer(_getScratchMemory(address));
    }
    private static native long _getScratchMemory(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setScratchMemory(NativeObject value) {
        checkNotNull();
        _setScratchMemory(address, value.getAddress());
    }
    private static native void _setScratchMemory(long address, long value);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getScratchAllocator() {
        checkNotNull();
        return NativeObject.wrapPointer(_getScratchAllocator(address));
    }
    private static native long _getScratchAllocator(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setScratchAllocator(NativeObject value) {
        checkNotNull();
        _setScratchAllocator(address, value.getAddress());
    }
    private static native void _setScratchAllocator(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getVersion() {
        checkNotNull();
        return _getVersion(address);
    }
    private static native int _getVersion(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setVersion(int value) {
        checkNotNull();
        _setVersion(address, value);
    }
    private static native void _setVersion(long address, int value);

    // Functions

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

}
