package physx.physics;

import physx.NativeObject;

public class PxArticulationDrive extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArticulationDrive wrapPointer(long address) {
        return address != 0L ? new PxArticulationDrive(address) : null;
    }
    
    public static PxArticulationDrive arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArticulationDrive(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxArticulationDrive
     */
    public static PxArticulationDrive createAt(long address) {
        __placement_new_PxArticulationDrive(address);
        PxArticulationDrive createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxArticulationDrive
     */
    public static <T> PxArticulationDrive createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArticulationDrive(address);
        PxArticulationDrive createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArticulationDrive(long address);

    /**
     * @param address   Pre-allocated memory, where the object is created.
     * @param stiffness WebIDL type: float
     * @param damping   WebIDL type: float
     * @param maxForce  WebIDL type: float
     * @param driveType WebIDL type: {@link PxArticulationDriveTypeEnum} [enum]
     * @return Stack allocated object of PxArticulationDrive
     */
    public static PxArticulationDrive createAt(long address, float stiffness, float damping, float maxForce, PxArticulationDriveTypeEnum driveType) {
        __placement_new_PxArticulationDrive(address, stiffness, damping, maxForce, driveType.value);
        PxArticulationDrive createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param stiffness WebIDL type: float
     * @param damping   WebIDL type: float
     * @param maxForce  WebIDL type: float
     * @param driveType WebIDL type: {@link PxArticulationDriveTypeEnum} [enum]
     * @return Stack allocated object of PxArticulationDrive
     */
    public static <T> PxArticulationDrive createAt(T allocator, Allocator<T> allocate, float stiffness, float damping, float maxForce, PxArticulationDriveTypeEnum driveType) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArticulationDrive(address, stiffness, damping, maxForce, driveType.value);
        PxArticulationDrive createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArticulationDrive(long address, float stiffness, float damping, float maxForce, int driveType);

    // Constructors

    public PxArticulationDrive() {
        address = _PxArticulationDrive();
    }
    private static native long _PxArticulationDrive();

    /**
     * @param stiffness WebIDL type: float
     * @param damping   WebIDL type: float
     * @param maxForce  WebIDL type: float
     * @param driveType WebIDL type: {@link PxArticulationDriveTypeEnum} [enum]
     */
    public PxArticulationDrive(float stiffness, float damping, float maxForce, PxArticulationDriveTypeEnum driveType) {
        address = _PxArticulationDrive(stiffness, damping, maxForce, driveType.value);
    }
    private static native long _PxArticulationDrive(float stiffness, float damping, float maxForce, int driveType);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getStiffness() {
        checkNotNull();
        return _getStiffness(address);
    }
    private static native float _getStiffness(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setStiffness(float value) {
        checkNotNull();
        _setStiffness(address, value);
    }
    private static native void _setStiffness(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getDamping() {
        checkNotNull();
        return _getDamping(address);
    }
    private static native float _getDamping(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setDamping(float value) {
        checkNotNull();
        _setDamping(address, value);
    }
    private static native void _setDamping(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMaxForce() {
        checkNotNull();
        return _getMaxForce(address);
    }
    private static native float _getMaxForce(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMaxForce(float value) {
        checkNotNull();
        _setMaxForce(address, value);
    }
    private static native void _setMaxForce(long address, float value);

    /**
     * @return WebIDL type: {@link PxArticulationDriveTypeEnum} [enum]
     */
    public PxArticulationDriveTypeEnum getDriveType() {
        checkNotNull();
        return PxArticulationDriveTypeEnum.forValue(_getDriveType(address));
    }
    private static native int _getDriveType(long address);

    /**
     * @param value WebIDL type: {@link PxArticulationDriveTypeEnum} [enum]
     */
    public void setDriveType(PxArticulationDriveTypeEnum value) {
        checkNotNull();
        _setDriveType(address, value.value);
    }
    private static native void _setDriveType(long address, int value);

}
