package physx.physics;


public class PxArticulationFixedTendon extends PxArticulationTendon {

    protected PxArticulationFixedTendon() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArticulationFixedTendon wrapPointer(long address) {
        return address != 0L ? new PxArticulationFixedTendon(address) : null;
    }
    
    public static PxArticulationFixedTendon arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArticulationFixedTendon(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param parent           WebIDL type: {@link PxArticulationTendonJoint}
     * @param axis             WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param coefficient      WebIDL type: float
     * @param recipCoefficient WebIDL type: float
     * @param link             WebIDL type: {@link PxArticulationLink}
     * @return WebIDL type: {@link PxArticulationTendonJoint}
     */
    public PxArticulationTendonJoint createTendonJoint(PxArticulationTendonJoint parent, PxArticulationAxisEnum axis, float coefficient, float recipCoefficient, PxArticulationLink link) {
        checkNotNull();
        return PxArticulationTendonJoint.wrapPointer(_createTendonJoint(address, parent.getAddress(), axis.value, coefficient, recipCoefficient, link.getAddress()));
    }
    private static native long _createTendonJoint(long address, long parent, int axis, float coefficient, float recipCoefficient, long link);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbTendonJoints() {
        checkNotNull();
        return _getNbTendonJoints(address);
    }
    private static native int _getNbTendonJoints(long address);

    /**
     * @param restLength WebIDL type: float
     */
    public void setRestLength(float restLength) {
        checkNotNull();
        _setRestLength(address, restLength);
    }
    private static native void _setRestLength(long address, float restLength);

    /**
     * @return WebIDL type: float
     */
    public float getRestLength() {
        checkNotNull();
        return _getRestLength(address);
    }
    private static native float _getRestLength(long address);

    /**
     * @param parameter WebIDL type: {@link PxArticulationTendonLimit} [Const, Ref]
     */
    public void setLimitParameters(PxArticulationTendonLimit parameter) {
        checkNotNull();
        _setLimitParameters(address, parameter.getAddress());
    }
    private static native void _setLimitParameters(long address, long parameter);

    /**
     * @return WebIDL type: {@link PxArticulationTendonLimit} [Value]
     */
    public PxArticulationTendonLimit getLimitParameters() {
        checkNotNull();
        return PxArticulationTendonLimit.wrapPointer(_getLimitParameters(address));
    }
    private static native long _getLimitParameters(long address);

}
