package physx.physics;

import physx.common.PxBase;
import physx.common.PxTransform;

public class PxArticulationJointReducedCoordinate extends PxBase {

    protected PxArticulationJointReducedCoordinate() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArticulationJointReducedCoordinate wrapPointer(long address) {
        return address != 0L ? new PxArticulationJointReducedCoordinate(address) : null;
    }
    
    public static PxArticulationJointReducedCoordinate arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArticulationJointReducedCoordinate(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: {@link PxArticulationLink} [Ref]
     */
    public PxArticulationLink getParentArticulationLink() {
        checkNotNull();
        return PxArticulationLink.wrapPointer(_getParentArticulationLink(address));
    }
    private static native long _getParentArticulationLink(long address);

    /**
     * @param pose WebIDL type: {@link PxTransform} [Const, Ref]
     */
    public void setParentPose(PxTransform pose) {
        checkNotNull();
        _setParentPose(address, pose.getAddress());
    }
    private static native void _setParentPose(long address, long pose);

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getParentPose() {
        checkNotNull();
        return PxTransform.wrapPointer(_getParentPose(address));
    }
    private static native long _getParentPose(long address);

    /**
     * @return WebIDL type: {@link PxArticulationLink} [Ref]
     */
    public PxArticulationLink getChildArticulationLink() {
        checkNotNull();
        return PxArticulationLink.wrapPointer(_getChildArticulationLink(address));
    }
    private static native long _getChildArticulationLink(long address);

    /**
     * @param pose WebIDL type: {@link PxTransform} [Const, Ref]
     */
    public void setChildPose(PxTransform pose) {
        checkNotNull();
        _setChildPose(address, pose.getAddress());
    }
    private static native void _setChildPose(long address, long pose);

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getChildPose() {
        checkNotNull();
        return PxTransform.wrapPointer(_getChildPose(address));
    }
    private static native long _getChildPose(long address);

    /**
     * @param jointType WebIDL type: {@link PxArticulationJointTypeEnum} [enum]
     */
    public void setJointType(PxArticulationJointTypeEnum jointType) {
        checkNotNull();
        _setJointType(address, jointType.value);
    }
    private static native void _setJointType(long address, int jointType);

    /**
     * @return WebIDL type: {@link PxArticulationJointTypeEnum} [enum]
     */
    public PxArticulationJointTypeEnum getJointType() {
        checkNotNull();
        return PxArticulationJointTypeEnum.forValue(_getJointType(address));
    }
    private static native int _getJointType(long address);

    /**
     * @param axis   WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param motion WebIDL type: {@link PxArticulationMotionEnum} [enum]
     */
    public void setMotion(PxArticulationAxisEnum axis, PxArticulationMotionEnum motion) {
        checkNotNull();
        _setMotion(address, axis.value, motion.value);
    }
    private static native void _setMotion(long address, int axis, int motion);

    /**
     * @param axis WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @return WebIDL type: {@link PxArticulationMotionEnum} [enum]
     */
    public PxArticulationMotionEnum getMotion(PxArticulationAxisEnum axis) {
        checkNotNull();
        return PxArticulationMotionEnum.forValue(_getMotion(address, axis.value));
    }
    private static native int _getMotion(long address, int axis);

    /**
     * @param axis  WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param limit WebIDL type: {@link PxArticulationLimit} [Const, Ref]
     */
    public void setLimitParams(PxArticulationAxisEnum axis, PxArticulationLimit limit) {
        checkNotNull();
        _setLimitParams(address, axis.value, limit.getAddress());
    }
    private static native void _setLimitParams(long address, int axis, long limit);

    /**
     * @param axis WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @return WebIDL type: {@link PxArticulationLimit} [Value]
     */
    public PxArticulationLimit getLimitParams(PxArticulationAxisEnum axis) {
        checkNotNull();
        return PxArticulationLimit.wrapPointer(_getLimitParams(address, axis.value));
    }
    private static native long _getLimitParams(long address, int axis);

    /**
     * @param axis  WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param drive WebIDL type: {@link PxArticulationDrive} [Const, Ref]
     */
    public void setDriveParams(PxArticulationAxisEnum axis, PxArticulationDrive drive) {
        checkNotNull();
        _setDriveParams(address, axis.value, drive.getAddress());
    }
    private static native void _setDriveParams(long address, int axis, long drive);

    /**
     * @param axis   WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param target WebIDL type: float
     */
    public void setDriveTarget(PxArticulationAxisEnum axis, float target) {
        checkNotNull();
        _setDriveTarget(address, axis.value, target);
    }
    private static native void _setDriveTarget(long address, int axis, float target);

    /**
     * @param axis     WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param target   WebIDL type: float
     * @param autowake WebIDL type: boolean
     */
    public void setDriveTarget(PxArticulationAxisEnum axis, float target, boolean autowake) {
        checkNotNull();
        _setDriveTarget(address, axis.value, target, autowake);
    }
    private static native void _setDriveTarget(long address, int axis, float target, boolean autowake);

    /**
     * @param axis WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @return WebIDL type: float
     */
    public float getDriveTarget(PxArticulationAxisEnum axis) {
        checkNotNull();
        return _getDriveTarget(address, axis.value);
    }
    private static native float _getDriveTarget(long address, int axis);

    /**
     * @param axis      WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param targetVel WebIDL type: float
     */
    public void setDriveVelocity(PxArticulationAxisEnum axis, float targetVel) {
        checkNotNull();
        _setDriveVelocity(address, axis.value, targetVel);
    }
    private static native void _setDriveVelocity(long address, int axis, float targetVel);

    /**
     * @param axis      WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param targetVel WebIDL type: float
     * @param autowake  WebIDL type: boolean
     */
    public void setDriveVelocity(PxArticulationAxisEnum axis, float targetVel, boolean autowake) {
        checkNotNull();
        _setDriveVelocity(address, axis.value, targetVel, autowake);
    }
    private static native void _setDriveVelocity(long address, int axis, float targetVel, boolean autowake);

    /**
     * @param axis WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @return WebIDL type: float
     */
    public float getDriveVelocity(PxArticulationAxisEnum axis) {
        checkNotNull();
        return _getDriveVelocity(address, axis.value);
    }
    private static native float _getDriveVelocity(long address, int axis);

    /**
     * @param axis     WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param armature WebIDL type: float
     */
    public void setArmature(PxArticulationAxisEnum axis, float armature) {
        checkNotNull();
        _setArmature(address, axis.value, armature);
    }
    private static native void _setArmature(long address, int axis, float armature);

    /**
     * @param axis WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @return WebIDL type: float
     */
    public float getArmature(PxArticulationAxisEnum axis) {
        checkNotNull();
        return _getArmature(address, axis.value);
    }
    private static native float _getArmature(long address, int axis);

    /**
     * @param coefficient WebIDL type: float
     */
    public void setFrictionCoefficient(float coefficient) {
        checkNotNull();
        _setFrictionCoefficient(address, coefficient);
    }
    private static native void _setFrictionCoefficient(long address, float coefficient);

    /**
     * @return WebIDL type: float
     */
    public float getFrictionCoefficient() {
        checkNotNull();
        return _getFrictionCoefficient(address);
    }
    private static native float _getFrictionCoefficient(long address);

    /**
     * @param maxJointV WebIDL type: float
     */
    public void setMaxJointVelocity(float maxJointV) {
        checkNotNull();
        _setMaxJointVelocity(address, maxJointV);
    }
    private static native void _setMaxJointVelocity(long address, float maxJointV);

    /**
     * @return WebIDL type: float
     */
    public float getMaxJointVelocity() {
        checkNotNull();
        return _getMaxJointVelocity(address);
    }
    private static native float _getMaxJointVelocity(long address);

    /**
     * @param axis     WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param jointPos WebIDL type: float
     */
    public void setJointPosition(PxArticulationAxisEnum axis, float jointPos) {
        checkNotNull();
        _setJointPosition(address, axis.value, jointPos);
    }
    private static native void _setJointPosition(long address, int axis, float jointPos);

    /**
     * @param axis WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @return WebIDL type: float
     */
    public float getJointPosition(PxArticulationAxisEnum axis) {
        checkNotNull();
        return _getJointPosition(address, axis.value);
    }
    private static native float _getJointPosition(long address, int axis);

    /**
     * @param axis     WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param jointVel WebIDL type: float
     */
    public void setJointVelocity(PxArticulationAxisEnum axis, float jointVel) {
        checkNotNull();
        _setJointVelocity(address, axis.value, jointVel);
    }
    private static native void _setJointVelocity(long address, int axis, float jointVel);

    /**
     * @param axis WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @return WebIDL type: float
     */
    public float getJointVelocity(PxArticulationAxisEnum axis) {
        checkNotNull();
        return _getJointVelocity(address, axis.value);
    }
    private static native float _getJointVelocity(long address, int axis);

}
