package physx.physics;


public class PxArticulationLink extends PxRigidBody {

    protected PxArticulationLink() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArticulationLink wrapPointer(long address) {
        return address != 0L ? new PxArticulationLink(address) : null;
    }
    
    public static PxArticulationLink arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArticulationLink(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: {@link PxArticulationReducedCoordinate} [Ref]
     */
    public PxArticulationReducedCoordinate getArticulation() {
        checkNotNull();
        return PxArticulationReducedCoordinate.wrapPointer(_getArticulation(address));
    }
    private static native long _getArticulation(long address);

    /**
     * @return WebIDL type: {@link PxArticulationJointReducedCoordinate} [Nullable]
     */
    public PxArticulationJointReducedCoordinate getInboundJoint() {
        checkNotNull();
        return PxArticulationJointReducedCoordinate.wrapPointer(_getInboundJoint(address));
    }
    private static native long _getInboundJoint(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getInboundJointDof() {
        checkNotNull();
        return _getInboundJointDof(address);
    }
    private static native int _getInboundJointDof(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbChildren() {
        checkNotNull();
        return _getNbChildren(address);
    }
    private static native int _getNbChildren(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getLinkIndex() {
        checkNotNull();
        return _getLinkIndex(address);
    }
    private static native int _getLinkIndex(long address);

    /**
     * @param cfm WebIDL type: float
     */
    public void setCfmScale(float cfm) {
        checkNotNull();
        _setCfmScale(address, cfm);
    }
    private static native void _setCfmScale(long address, float cfm);

    /**
     * @return WebIDL type: float
     */
    public float getCfmScale() {
        checkNotNull();
        return _getCfmScale(address);
    }
    private static native float _getCfmScale(long address);

}
