package physx.physics;

import physx.common.PxBase;
import physx.common.PxBounds3;
import physx.common.PxTransform;
import physx.common.PxVec3;

public class PxArticulationReducedCoordinate extends PxBase {

    protected PxArticulationReducedCoordinate() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArticulationReducedCoordinate wrapPointer(long address) {
        return address != 0L ? new PxArticulationReducedCoordinate(address) : null;
    }
    
    public static PxArticulationReducedCoordinate arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArticulationReducedCoordinate(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: {@link PxScene}
     */
    public PxScene getScene() {
        checkNotNull();
        return PxScene.wrapPointer(_getScene(address));
    }
    private static native long _getScene(long address);

    /**
     * @param minPositionIters WebIDL type: unsigned long
     */
    public void setSolverIterationCounts(int minPositionIters) {
        checkNotNull();
        _setSolverIterationCounts(address, minPositionIters);
    }
    private static native void _setSolverIterationCounts(long address, int minPositionIters);

    /**
     * @param minPositionIters WebIDL type: unsigned long
     * @param minVelocityIters WebIDL type: unsigned long
     */
    public void setSolverIterationCounts(int minPositionIters, int minVelocityIters) {
        checkNotNull();
        _setSolverIterationCounts(address, minPositionIters, minVelocityIters);
    }
    private static native void _setSolverIterationCounts(long address, int minPositionIters, int minVelocityIters);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isSleeping() {
        checkNotNull();
        return _isSleeping(address);
    }
    private static native boolean _isSleeping(long address);

    /**
     * @param threshold WebIDL type: float
     */
    public void setSleepThreshold(float threshold) {
        checkNotNull();
        _setSleepThreshold(address, threshold);
    }
    private static native void _setSleepThreshold(long address, float threshold);

    /**
     * @return WebIDL type: float
     */
    public float getSleepThreshold() {
        checkNotNull();
        return _getSleepThreshold(address);
    }
    private static native float _getSleepThreshold(long address);

    /**
     * @param threshold WebIDL type: float
     */
    public void setStabilizationThreshold(float threshold) {
        checkNotNull();
        _setStabilizationThreshold(address, threshold);
    }
    private static native void _setStabilizationThreshold(long address, float threshold);

    /**
     * @return WebIDL type: float
     */
    public float getStabilizationThreshold() {
        checkNotNull();
        return _getStabilizationThreshold(address);
    }
    private static native float _getStabilizationThreshold(long address);

    /**
     * @param wakeCounterValue WebIDL type: float
     */
    public void setWakeCounter(float wakeCounterValue) {
        checkNotNull();
        _setWakeCounter(address, wakeCounterValue);
    }
    private static native void _setWakeCounter(long address, float wakeCounterValue);

    /**
     * @return WebIDL type: float
     */
    public float getWakeCounter() {
        checkNotNull();
        return _getWakeCounter(address);
    }
    private static native float _getWakeCounter(long address);

    public void wakeUp() {
        checkNotNull();
        _wakeUp(address);
    }
    private static native void _wakeUp(long address);

    public void putToSleep() {
        checkNotNull();
        _putToSleep(address);
    }
    private static native void _putToSleep(long address);

    /**
     * @param maxLinerVelocity WebIDL type: float
     */
    public void setMaxCOMLinearVelocity(float maxLinerVelocity) {
        checkNotNull();
        _setMaxCOMLinearVelocity(address, maxLinerVelocity);
    }
    private static native void _setMaxCOMLinearVelocity(long address, float maxLinerVelocity);

    /**
     * @return WebIDL type: float
     */
    public float getMaxCOMLinearVelocity() {
        checkNotNull();
        return _getMaxCOMLinearVelocity(address);
    }
    private static native float _getMaxCOMLinearVelocity(long address);

    /**
     * @param maxAngularVelocity WebIDL type: float
     */
    public void setMaxCOMAngularVelocity(float maxAngularVelocity) {
        checkNotNull();
        _setMaxCOMAngularVelocity(address, maxAngularVelocity);
    }
    private static native void _setMaxCOMAngularVelocity(long address, float maxAngularVelocity);

    /**
     * @return WebIDL type: float
     */
    public float getMaxCOMAngularVelocity() {
        checkNotNull();
        return _getMaxCOMAngularVelocity(address);
    }
    private static native float _getMaxCOMAngularVelocity(long address);

    /**
     * @param parent WebIDL type: {@link PxArticulationLink} [Nullable]
     * @param pose   WebIDL type: {@link PxTransform} [Const, Ref]
     * @return WebIDL type: {@link PxArticulationLink}
     */
    public PxArticulationLink createLink(PxArticulationLink parent, PxTransform pose) {
        checkNotNull();
        return PxArticulationLink.wrapPointer(_createLink(address, (parent != null ? parent.getAddress() : 0L), pose.getAddress()));
    }
    private static native long _createLink(long address, long parent, long pose);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbLinks() {
        checkNotNull();
        return _getNbLinks(address);
    }
    private static native int _getNbLinks(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbShapes() {
        checkNotNull();
        return _getNbShapes(address);
    }
    private static native int _getNbShapes(long address);

    /**
     * @param name WebIDL type: DOMString [Const]
     */
    public void setName(String name) {
        checkNotNull();
        _setName(address, name);
    }
    private static native void _setName(long address, String name);

    /**
     * @return WebIDL type: DOMString [Const]
     */
    public String getName() {
        checkNotNull();
        return _getName(address);
    }
    private static native String _getName(long address);

    /**
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public PxBounds3 getWorldBounds() {
        checkNotNull();
        return PxBounds3.wrapPointer(_getWorldBounds(address));
    }
    private static native long _getWorldBounds(long address);

    /**
     * @param inflation WebIDL type: float
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public PxBounds3 getWorldBounds(float inflation) {
        checkNotNull();
        return PxBounds3.wrapPointer(_getWorldBounds(address, inflation));
    }
    private static native long _getWorldBounds(long address, float inflation);

    /**
     * @return WebIDL type: {@link PxAggregate}
     */
    public PxAggregate getAggregate() {
        checkNotNull();
        return PxAggregate.wrapPointer(_getAggregate(address));
    }
    private static native long _getAggregate(long address);

    /**
     * @param flags WebIDL type: {@link PxArticulationFlags} [Ref]
     */
    public void setArticulationFlags(PxArticulationFlags flags) {
        checkNotNull();
        _setArticulationFlags(address, flags.getAddress());
    }
    private static native void _setArticulationFlags(long address, long flags);

    /**
     * @param flag  WebIDL type: {@link PxArticulationFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setArticulationFlag(PxArticulationFlagEnum flag, boolean value) {
        checkNotNull();
        _setArticulationFlag(address, flag.value, value);
    }
    private static native void _setArticulationFlag(long address, int flag, boolean value);

    /**
     * @return WebIDL type: {@link PxArticulationFlags} [Value]
     */
    public PxArticulationFlags getArticulationFlags() {
        checkNotNull();
        return PxArticulationFlags.wrapPointer(_getArticulationFlags(address));
    }
    private static native long _getArticulationFlags(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getDofs() {
        checkNotNull();
        return _getDofs(address);
    }
    private static native int _getDofs(long address);

    /**
     * @return WebIDL type: {@link PxArticulationCache}
     */
    public PxArticulationCache createCache() {
        checkNotNull();
        return PxArticulationCache.wrapPointer(_createCache(address));
    }
    private static native long _createCache(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getCacheDataSize() {
        checkNotNull();
        return _getCacheDataSize(address);
    }
    private static native int _getCacheDataSize(long address);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void zeroCache(PxArticulationCache cache) {
        checkNotNull();
        _zeroCache(address, cache.getAddress());
    }
    private static native void _zeroCache(long address, long cache);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     * @param flags WebIDL type: {@link PxArticulationCacheFlags} [Ref]
     */
    public void applyCache(PxArticulationCache cache, PxArticulationCacheFlags flags) {
        checkNotNull();
        _applyCache(address, cache.getAddress(), flags.getAddress());
    }
    private static native void _applyCache(long address, long cache, long flags);

    /**
     * @param cache    WebIDL type: {@link PxArticulationCache} [Ref]
     * @param flags    WebIDL type: {@link PxArticulationCacheFlags} [Ref]
     * @param autowake WebIDL type: boolean
     */
    public void applyCache(PxArticulationCache cache, PxArticulationCacheFlags flags, boolean autowake) {
        checkNotNull();
        _applyCache(address, cache.getAddress(), flags.getAddress(), autowake);
    }
    private static native void _applyCache(long address, long cache, long flags, boolean autowake);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     * @param flags WebIDL type: {@link PxArticulationCacheFlags} [Const, Ref]
     */
    public void copyInternalStateToCache(PxArticulationCache cache, PxArticulationCacheFlags flags) {
        checkNotNull();
        _copyInternalStateToCache(address, cache.getAddress(), flags.getAddress());
    }
    private static native void _copyInternalStateToCache(long address, long cache, long flags);

    public void commonInit() {
        checkNotNull();
        _commonInit(address);
    }
    private static native void _commonInit(long address);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void computeGeneralizedGravityForce(PxArticulationCache cache) {
        checkNotNull();
        _computeGeneralizedGravityForce(address, cache.getAddress());
    }
    private static native void _computeGeneralizedGravityForce(long address, long cache);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void computeCoriolisAndCentrifugalForce(PxArticulationCache cache) {
        checkNotNull();
        _computeCoriolisAndCentrifugalForce(address, cache.getAddress());
    }
    private static native void _computeCoriolisAndCentrifugalForce(long address, long cache);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void computeGeneralizedExternalForce(PxArticulationCache cache) {
        checkNotNull();
        _computeGeneralizedExternalForce(address, cache.getAddress());
    }
    private static native void _computeGeneralizedExternalForce(long address, long cache);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void computeJointAcceleration(PxArticulationCache cache) {
        checkNotNull();
        _computeJointAcceleration(address, cache.getAddress());
    }
    private static native void _computeJointAcceleration(long address, long cache);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void computeJointForce(PxArticulationCache cache) {
        checkNotNull();
        _computeJointForce(address, cache.getAddress());
    }
    private static native void _computeJointForce(long address, long cache);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void computeCoefficientMatrix(PxArticulationCache cache) {
        checkNotNull();
        _computeCoefficientMatrix(address, cache.getAddress());
    }
    private static native void _computeCoefficientMatrix(long address, long cache);

    /**
     * @param cache WebIDL type: {@link PxArticulationCache} [Ref]
     */
    public void computeGeneralizedMassMatrix(PxArticulationCache cache) {
        checkNotNull();
        _computeGeneralizedMassMatrix(address, cache.getAddress());
    }
    private static native void _computeGeneralizedMassMatrix(long address, long cache);

    /**
     * @param joint WebIDL type: {@link PxConstraint}
     */
    public void addLoopJoint(PxConstraint joint) {
        checkNotNull();
        _addLoopJoint(address, joint.getAddress());
    }
    private static native void _addLoopJoint(long address, long joint);

    /**
     * @param joint WebIDL type: {@link PxConstraint}
     */
    public void removeLoopJoint(PxConstraint joint) {
        checkNotNull();
        _removeLoopJoint(address, joint.getAddress());
    }
    private static native void _removeLoopJoint(long address, long joint);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbLoopJoints() {
        checkNotNull();
        return _getNbLoopJoints(address);
    }
    private static native int _getNbLoopJoints(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getCoefficientMatrixSize() {
        checkNotNull();
        return _getCoefficientMatrixSize(address);
    }
    private static native int _getCoefficientMatrixSize(long address);

    /**
     * @param pose WebIDL type: {@link PxTransform} [Const, Ref]
     */
    public void setRootGlobalPose(PxTransform pose) {
        checkNotNull();
        _setRootGlobalPose(address, pose.getAddress());
    }
    private static native void _setRootGlobalPose(long address, long pose);

    /**
     * @param pose     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param autowake WebIDL type: boolean
     */
    public void setRootGlobalPose(PxTransform pose, boolean autowake) {
        checkNotNull();
        _setRootGlobalPose(address, pose.getAddress(), autowake);
    }
    private static native void _setRootGlobalPose(long address, long pose, boolean autowake);

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getRootGlobalPose() {
        checkNotNull();
        return PxTransform.wrapPointer(_getRootGlobalPose(address));
    }
    private static native long _getRootGlobalPose(long address);

    /**
     * @param linearVelocity WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setRootLinearVelocity(PxVec3 linearVelocity) {
        checkNotNull();
        _setRootLinearVelocity(address, linearVelocity.getAddress());
    }
    private static native void _setRootLinearVelocity(long address, long linearVelocity);

    /**
     * @param linearVelocity WebIDL type: {@link PxVec3} [Const, Ref]
     * @param autowake       WebIDL type: boolean
     */
    public void setRootLinearVelocity(PxVec3 linearVelocity, boolean autowake) {
        checkNotNull();
        _setRootLinearVelocity(address, linearVelocity.getAddress(), autowake);
    }
    private static native void _setRootLinearVelocity(long address, long linearVelocity, boolean autowake);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getRootLinearVelocity() {
        checkNotNull();
        return PxVec3.wrapPointer(_getRootLinearVelocity(address));
    }
    private static native long _getRootLinearVelocity(long address);

    /**
     * @param angularVelocity WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setRootAngularVelocity(PxVec3 angularVelocity) {
        checkNotNull();
        _setRootAngularVelocity(address, angularVelocity.getAddress());
    }
    private static native void _setRootAngularVelocity(long address, long angularVelocity);

    /**
     * @param angularVelocity WebIDL type: {@link PxVec3} [Const, Ref]
     * @param autowake        WebIDL type: boolean
     */
    public void setRootAngularVelocity(PxVec3 angularVelocity, boolean autowake) {
        checkNotNull();
        _setRootAngularVelocity(address, angularVelocity.getAddress(), autowake);
    }
    private static native void _setRootAngularVelocity(long address, long angularVelocity, boolean autowake);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getRootAngularVelocity() {
        checkNotNull();
        return PxVec3.wrapPointer(_getRootAngularVelocity(address));
    }
    private static native long _getRootAngularVelocity(long address);

    /**
     * @param linkId WebIDL type: unsigned long
     * @return WebIDL type: {@link PxSpatialVelocity} [Value]
     */
    public PxSpatialVelocity getLinkAcceleration(int linkId) {
        checkNotNull();
        return PxSpatialVelocity.wrapPointer(_getLinkAcceleration(address, linkId));
    }
    private static native long _getLinkAcceleration(long address, int linkId);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getGpuArticulationIndex() {
        checkNotNull();
        return _getGpuArticulationIndex(address);
    }
    private static native int _getGpuArticulationIndex(long address);

    /**
     * @return WebIDL type: {@link PxArticulationSpatialTendon}
     */
    public PxArticulationSpatialTendon createSpatialTendon() {
        checkNotNull();
        return PxArticulationSpatialTendon.wrapPointer(_createSpatialTendon(address));
    }
    private static native long _createSpatialTendon(long address);

    /**
     * @return WebIDL type: {@link PxArticulationFixedTendon}
     */
    public PxArticulationFixedTendon createFixedTendon() {
        checkNotNull();
        return PxArticulationFixedTendon.wrapPointer(_createFixedTendon(address));
    }
    private static native long _createFixedTendon(long address);

    /**
     * @param link         WebIDL type: {@link PxArticulationLink}
     * @param relativePose WebIDL type: {@link PxTransform} [Const, Ref]
     * @return WebIDL type: {@link PxArticulationSensor}
     */
    public PxArticulationSensor createSensor(PxArticulationLink link, PxTransform relativePose) {
        checkNotNull();
        return PxArticulationSensor.wrapPointer(_createSensor(address, link.getAddress(), relativePose.getAddress()));
    }
    private static native long _createSensor(long address, long link, long relativePose);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbSpatialTendons() {
        checkNotNull();
        return _getNbSpatialTendons(address);
    }
    private static native int _getNbSpatialTendons(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbFixedTendons() {
        checkNotNull();
        return _getNbFixedTendons(address);
    }
    private static native int _getNbFixedTendons(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbSensors() {
        checkNotNull();
        return _getNbSensors(address);
    }
    private static native int _getNbSensors(long address);

    /**
     * @param flags WebIDL type: {@link PxArticulationKinematicFlags} [Ref]
     */
    public void updateKinematic(PxArticulationKinematicFlags flags) {
        checkNotNull();
        _updateKinematic(address, flags.getAddress());
    }
    private static native void _updateKinematic(long address, long flags);

}
