package physx.physics;

import physx.common.PxVec3;

public class PxArticulationSpatialTendon extends PxArticulationTendon {

    protected PxArticulationSpatialTendon() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArticulationSpatialTendon wrapPointer(long address) {
        return address != 0L ? new PxArticulationSpatialTendon(address) : null;
    }
    
    public static PxArticulationSpatialTendon arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArticulationSpatialTendon(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param parent         WebIDL type: {@link PxArticulationAttachment}
     * @param coefficient    WebIDL type: float
     * @param relativeOffset WebIDL type: {@link PxVec3} [Const, Ref]
     * @param link           WebIDL type: {@link PxArticulationLink}
     * @return WebIDL type: {@link PxArticulationAttachment}
     */
    public PxArticulationAttachment createAttachment(PxArticulationAttachment parent, float coefficient, PxVec3 relativeOffset, PxArticulationLink link) {
        checkNotNull();
        return PxArticulationAttachment.wrapPointer(_createAttachment(address, parent.getAddress(), coefficient, relativeOffset.getAddress(), link.getAddress()));
    }
    private static native long _createAttachment(long address, long parent, float coefficient, long relativeOffset, long link);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbAttachments() {
        checkNotNull();
        return _getNbAttachments(address);
    }
    private static native int _getNbAttachments(long address);

}
