package physx.physics;

import physx.common.PxBase;

public class PxArticulationTendon extends PxBase {

    protected PxArticulationTendon() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArticulationTendon wrapPointer(long address) {
        return address != 0L ? new PxArticulationTendon(address) : null;
    }
    
    public static PxArticulationTendon arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArticulationTendon(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param stiffness WebIDL type: float
     */
    public void setStiffness(float stiffness) {
        checkNotNull();
        _setStiffness(address, stiffness);
    }
    private static native void _setStiffness(long address, float stiffness);

    /**
     * @return WebIDL type: float
     */
    public float getStiffness() {
        checkNotNull();
        return _getStiffness(address);
    }
    private static native float _getStiffness(long address);

    /**
     * @param damping WebIDL type: float
     */
    public void setDamping(float damping) {
        checkNotNull();
        _setDamping(address, damping);
    }
    private static native void _setDamping(long address, float damping);

    /**
     * @return WebIDL type: float
     */
    public float getDamping() {
        checkNotNull();
        return _getDamping(address);
    }
    private static native float _getDamping(long address);

    /**
     * @param stiffness WebIDL type: float
     */
    public void setLimitStiffness(float stiffness) {
        checkNotNull();
        _setLimitStiffness(address, stiffness);
    }
    private static native void _setLimitStiffness(long address, float stiffness);

    /**
     * @return WebIDL type: float
     */
    public float getLimitStiffness() {
        checkNotNull();
        return _getLimitStiffness(address);
    }
    private static native float _getLimitStiffness(long address);

    /**
     * @param offset WebIDL type: float
     */
    public void setOffset(float offset) {
        checkNotNull();
        _setOffset(address, offset);
    }
    private static native void _setOffset(long address, float offset);

    /**
     * @param offset   WebIDL type: float
     * @param autowake WebIDL type: boolean
     */
    public void setOffset(float offset, boolean autowake) {
        checkNotNull();
        _setOffset(address, offset, autowake);
    }
    private static native void _setOffset(long address, float offset, boolean autowake);

    /**
     * @return WebIDL type: float
     */
    public float getOffset() {
        checkNotNull();
        return _getOffset(address);
    }
    private static native float _getOffset(long address);

    /**
     * @return WebIDL type: {@link PxArticulationReducedCoordinate}
     */
    public PxArticulationReducedCoordinate getArticulation() {
        checkNotNull();
        return PxArticulationReducedCoordinate.wrapPointer(_getArticulation(address));
    }
    private static native long _getArticulation(long address);

}
