package physx.physics;

import physx.NativeObject;

public class PxArticulationTendonJoint extends NativeObject {

    protected PxArticulationTendonJoint() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArticulationTendonJoint wrapPointer(long address) {
        return address != 0L ? new PxArticulationTendonJoint(address) : null;
    }
    
    public static PxArticulationTendonJoint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArticulationTendonJoint(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getUserData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getUserData(address));
    }
    private static native long _getUserData(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setUserData(NativeObject value) {
        checkNotNull();
        _setUserData(address, value.getAddress());
    }
    private static native void _setUserData(long address, long value);

    // Functions

    /**
     * @param axis             WebIDL type: {@link PxArticulationAxisEnum} [enum]
     * @param coefficient      WebIDL type: float
     * @param recipCoefficient WebIDL type: float
     */
    public void setCoefficient(PxArticulationAxisEnum axis, float coefficient, float recipCoefficient) {
        checkNotNull();
        _setCoefficient(address, axis.value, coefficient, recipCoefficient);
    }
    private static native void _setCoefficient(long address, int axis, float coefficient, float recipCoefficient);

    /**
     * @return WebIDL type: {@link PxArticulationLink}
     */
    public PxArticulationLink getLink() {
        checkNotNull();
        return PxArticulationLink.wrapPointer(_getLink(address));
    }
    private static native long _getLink(long address);

    /**
     * @return WebIDL type: {@link PxArticulationTendonJoint}
     */
    public PxArticulationTendonJoint getParent() {
        checkNotNull();
        return PxArticulationTendonJoint.wrapPointer(_getParent(address));
    }
    private static native long _getParent(long address);

    /**
     * @return WebIDL type: {@link PxArticulationFixedTendon}
     */
    public PxArticulationFixedTendon getTendon() {
        checkNotNull();
        return PxArticulationFixedTendon.wrapPointer(_getTendon(address));
    }
    private static native long _getTendon(long address);

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

}
