package physx.physics;

import physx.NativeObject;

public class PxBroadPhaseCaps extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxBroadPhaseCaps wrapPointer(long address) {
        return address != 0L ? new PxBroadPhaseCaps(address) : null;
    }
    
    public static PxBroadPhaseCaps arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxBroadPhaseCaps(long address) {
        super(address);
    }

    // Constructors

    public PxBroadPhaseCaps() {
        address = _PxBroadPhaseCaps();
    }
    private static native long _PxBroadPhaseCaps();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMMaxNbRegions() {
        checkNotNull();
        return _getMMaxNbRegions(address);
    }
    private static native int _getMMaxNbRegions(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMMaxNbRegions(int value) {
        checkNotNull();
        _setMMaxNbRegions(address, value);
    }
    private static native void _setMMaxNbRegions(long address, int value);

}
