package physx.physics;

import physx.NativeObject;
import physx.common.PxBounds3;

public class PxBroadPhaseRegion extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxBroadPhaseRegion wrapPointer(long address) {
        return address != 0L ? new PxBroadPhaseRegion(address) : null;
    }
    
    public static PxBroadPhaseRegion arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxBroadPhaseRegion(long address) {
        super(address);
    }

    // Constructors

    public PxBroadPhaseRegion() {
        address = _PxBroadPhaseRegion();
    }
    private static native long _PxBroadPhaseRegion();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public PxBounds3 getMBounds() {
        checkNotNull();
        return PxBounds3.wrapPointer(_getMBounds(address));
    }
    private static native long _getMBounds(long address);

    /**
     * @param value WebIDL type: {@link PxBounds3} [Value]
     */
    public void setMBounds(PxBounds3 value) {
        checkNotNull();
        _setMBounds(address, value.getAddress());
    }
    private static native void _setMBounds(long address, long value);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getMUserData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getMUserData(address));
    }
    private static native long _getMUserData(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setMUserData(NativeObject value) {
        checkNotNull();
        _setMUserData(address, value.getAddress());
    }
    private static native void _setMUserData(long address, long value);

}
