package physx.physics;

import physx.NativeObject;

public class PxBroadPhaseRegionInfo extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxBroadPhaseRegionInfo wrapPointer(long address) {
        return address != 0L ? new PxBroadPhaseRegionInfo(address) : null;
    }
    
    public static PxBroadPhaseRegionInfo arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxBroadPhaseRegionInfo(long address) {
        super(address);
    }

    // Constructors

    public PxBroadPhaseRegionInfo() {
        address = _PxBroadPhaseRegionInfo();
    }
    private static native long _PxBroadPhaseRegionInfo();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxBroadPhaseRegion} [Value]
     */
    public PxBroadPhaseRegion getMRegion() {
        checkNotNull();
        return PxBroadPhaseRegion.wrapPointer(_getMRegion(address));
    }
    private static native long _getMRegion(long address);

    /**
     * @param value WebIDL type: {@link PxBroadPhaseRegion} [Value]
     */
    public void setMRegion(PxBroadPhaseRegion value) {
        checkNotNull();
        _setMRegion(address, value.getAddress());
    }
    private static native void _setMRegion(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMNbStaticObjects() {
        checkNotNull();
        return _getMNbStaticObjects(address);
    }
    private static native int _getMNbStaticObjects(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMNbStaticObjects(int value) {
        checkNotNull();
        _setMNbStaticObjects(address, value);
    }
    private static native void _setMNbStaticObjects(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMNbDynamicObjects() {
        checkNotNull();
        return _getMNbDynamicObjects(address);
    }
    private static native int _getMNbDynamicObjects(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMNbDynamicObjects(int value) {
        checkNotNull();
        _setMNbDynamicObjects(address, value);
    }
    private static native void _setMNbDynamicObjects(long address, int value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getMActive() {
        checkNotNull();
        return _getMActive(address);
    }
    private static native boolean _getMActive(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setMActive(boolean value) {
        checkNotNull();
        _setMActive(address, value);
    }
    private static native void _setMActive(long address, boolean value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getMOverlap() {
        checkNotNull();
        return _getMOverlap(address);
    }
    private static native boolean _getMOverlap(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setMOverlap(boolean value) {
        checkNotNull();
        _setMOverlap(address, value);
    }
    private static native void _setMOverlap(long address, boolean value);

}
