package physx.physics;

import physx.NativeObject;
import physx.common.PxBase;
import physx.common.PxVec3;

public class PxConstraintConnector extends NativeObject {

    protected PxConstraintConnector() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxConstraintConnector wrapPointer(long address) {
        return address != 0L ? new PxConstraintConnector(address) : null;
    }
    
    public static PxConstraintConnector arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxConstraintConnector(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    public void prepareData() {
        checkNotNull();
        _prepareData(address);
    }
    private static native void _prepareData(long address);

    public void updateOmniPvdProperties() {
        checkNotNull();
        _updateOmniPvdProperties(address);
    }
    private static native void _updateOmniPvdProperties(long address);

    public void onConstraintRelease() {
        checkNotNull();
        _onConstraintRelease(address);
    }
    private static native void _onConstraintRelease(long address);

    /**
     * @param actor WebIDL type: unsigned long
     */
    public void onComShift(int actor) {
        checkNotNull();
        _onComShift(address, actor);
    }
    private static native void _onComShift(long address, int actor);

    /**
     * @param shift WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void onOriginShift(PxVec3 shift) {
        checkNotNull();
        _onOriginShift(address, shift.getAddress());
    }
    private static native void _onOriginShift(long address, long shift);

    /**
     * @return WebIDL type: {@link PxBase}
     */
    public PxBase getSerializable() {
        checkNotNull();
        return PxBase.wrapPointer(_getSerializable(address));
    }
    private static native long _getSerializable(long address);

    /**
     * @return WebIDL type: {@link PxConstraintSolverPrep} [Value]
     */
    public PxConstraintSolverPrep getPrep() {
        checkNotNull();
        return PxConstraintSolverPrep.wrapPointer(_getPrep(address));
    }
    private static native long _getPrep(long address);

    public void getConstantBlock() {
        checkNotNull();
        _getConstantBlock(address);
    }
    private static native void _getConstantBlock(long address);

    /**
     * @param constraint WebIDL type: {@link PxConstraint}
     */
    public void connectToConstraint(PxConstraint constraint) {
        checkNotNull();
        _connectToConstraint(address, constraint.getAddress());
    }
    private static native void _connectToConstraint(long address, long constraint);

}
