package physx.physics;

import physx.NativeObject;

public class PxConstraintFlags extends NativeObject {

    protected PxConstraintFlags() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxConstraintFlags wrapPointer(long address) {
        return address != 0L ? new PxConstraintFlags(address) : null;
    }
    
    public static PxConstraintFlags arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxConstraintFlags(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param flags   WebIDL type: unsigned short
     * @return Stack allocated object of PxConstraintFlags
     */
    public static PxConstraintFlags createAt(long address, short flags) {
        __placement_new_PxConstraintFlags(address, flags);
        PxConstraintFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param flags     WebIDL type: unsigned short
     * @return Stack allocated object of PxConstraintFlags
     */
    public static <T> PxConstraintFlags createAt(T allocator, Allocator<T> allocate, short flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxConstraintFlags(address, flags);
        PxConstraintFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxConstraintFlags(long address, short flags);

    // Constructors

    /**
     * @param flags WebIDL type: unsigned short
     */
    public PxConstraintFlags(short flags) {
        address = _PxConstraintFlags(flags);
    }
    private static native long _PxConstraintFlags(short flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxConstraintFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(PxConstraintFlagEnum flag) {
        checkNotNull();
        return _isSet(address, flag.value);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxConstraintFlagEnum} [enum]
     */
    public void raise(PxConstraintFlagEnum flag) {
        checkNotNull();
        _raise(address, flag.value);
    }
    private static native void _raise(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxConstraintFlagEnum} [enum]
     */
    public void clear(PxConstraintFlagEnum flag) {
        checkNotNull();
        _clear(address, flag.value);
    }
    private static native void _clear(long address, int flag);

}
