package physx.physics;

import physx.NativeObject;

public class PxFilterData extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxFilterData wrapPointer(long address) {
        return address != 0L ? new PxFilterData(address) : null;
    }
    
    public static PxFilterData arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxFilterData(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxFilterData
     */
    public static PxFilterData createAt(long address) {
        __placement_new_PxFilterData(address);
        PxFilterData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxFilterData
     */
    public static <T> PxFilterData createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxFilterData(address);
        PxFilterData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxFilterData(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param w0      WebIDL type: unsigned long
     * @param w1      WebIDL type: unsigned long
     * @param w2      WebIDL type: unsigned long
     * @param w3      WebIDL type: unsigned long
     * @return Stack allocated object of PxFilterData
     */
    public static PxFilterData createAt(long address, int w0, int w1, int w2, int w3) {
        __placement_new_PxFilterData(address, w0, w1, w2, w3);
        PxFilterData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param w0        WebIDL type: unsigned long
     * @param w1        WebIDL type: unsigned long
     * @param w2        WebIDL type: unsigned long
     * @param w3        WebIDL type: unsigned long
     * @return Stack allocated object of PxFilterData
     */
    public static <T> PxFilterData createAt(T allocator, Allocator<T> allocate, int w0, int w1, int w2, int w3) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxFilterData(address, w0, w1, w2, w3);
        PxFilterData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxFilterData(long address, int w0, int w1, int w2, int w3);

    // Constructors

    public PxFilterData() {
        address = _PxFilterData();
    }
    private static native long _PxFilterData();

    /**
     * @param w0 WebIDL type: unsigned long
     * @param w1 WebIDL type: unsigned long
     * @param w2 WebIDL type: unsigned long
     * @param w3 WebIDL type: unsigned long
     */
    public PxFilterData(int w0, int w1, int w2, int w3) {
        address = _PxFilterData(w0, w1, w2, w3);
    }
    private static native long _PxFilterData(int w0, int w1, int w2, int w3);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getWord0() {
        checkNotNull();
        return _getWord0(address);
    }
    private static native int _getWord0(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setWord0(int value) {
        checkNotNull();
        _setWord0(address, value);
    }
    private static native void _setWord0(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getWord1() {
        checkNotNull();
        return _getWord1(address);
    }
    private static native int _getWord1(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setWord1(int value) {
        checkNotNull();
        _setWord1(address, value);
    }
    private static native void _setWord1(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getWord2() {
        checkNotNull();
        return _getWord2(address);
    }
    private static native int _getWord2(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setWord2(int value) {
        checkNotNull();
        _setWord2(address, value);
    }
    private static native void _setWord2(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getWord3() {
        checkNotNull();
        return _getWord3(address);
    }
    private static native int _getWord3(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setWord3(int value) {
        checkNotNull();
        _setWord3(address, value);
    }
    private static native void _setWord3(long address, int value);

}
