package physx.physics;

import physx.common.PxVec3;

public class PxLocationHit extends PxQueryHit {

    protected PxLocationHit() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxLocationHit wrapPointer(long address) {
        return address != 0L ? new PxLocationHit(address) : null;
    }
    
    public static PxLocationHit arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxLocationHit(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxHitFlags} [Value]
     */
    public PxHitFlags getFlags() {
        checkNotNull();
        return PxHitFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value WebIDL type: {@link PxHitFlags} [Value]
     */
    public void setFlags(PxHitFlags value) {
        checkNotNull();
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getPosition() {
        checkNotNull();
        return PxVec3.wrapPointer(_getPosition(address));
    }
    private static native long _getPosition(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setPosition(PxVec3 value) {
        checkNotNull();
        _setPosition(address, value.getAddress());
    }
    private static native void _setPosition(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getNormal() {
        checkNotNull();
        return PxVec3.wrapPointer(_getNormal(address));
    }
    private static native long _getNormal(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setNormal(PxVec3 value) {
        checkNotNull();
        _setNormal(address, value.getAddress());
    }
    private static native void _setNormal(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getDistance() {
        checkNotNull();
        return _getDistance(address);
    }
    private static native float _getDistance(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setDistance(float value) {
        checkNotNull();
        _setDistance(address, value);
    }
    private static native void _setDistance(long address, float value);

}
