package physx.physics;

import physx.NativeObject;

public class PxQueryFilterData extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxQueryFilterData wrapPointer(long address) {
        return address != 0L ? new PxQueryFilterData(address) : null;
    }
    
    public static PxQueryFilterData arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxQueryFilterData(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxQueryFilterData
     */
    public static PxQueryFilterData createAt(long address) {
        __placement_new_PxQueryFilterData(address);
        PxQueryFilterData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxQueryFilterData
     */
    public static <T> PxQueryFilterData createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxQueryFilterData(address);
        PxQueryFilterData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxQueryFilterData(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param fd      WebIDL type: {@link PxFilterData} [Const, Ref]
     * @param f       WebIDL type: {@link PxQueryFlags} [Ref]
     * @return Stack allocated object of PxQueryFilterData
     */
    public static PxQueryFilterData createAt(long address, PxFilterData fd, PxQueryFlags f) {
        __placement_new_PxQueryFilterData(address, fd.getAddress(), f.getAddress());
        PxQueryFilterData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param fd        WebIDL type: {@link PxFilterData} [Const, Ref]
     * @param f         WebIDL type: {@link PxQueryFlags} [Ref]
     * @return Stack allocated object of PxQueryFilterData
     */
    public static <T> PxQueryFilterData createAt(T allocator, Allocator<T> allocate, PxFilterData fd, PxQueryFlags f) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxQueryFilterData(address, fd.getAddress(), f.getAddress());
        PxQueryFilterData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxQueryFilterData(long address, long fd, long f);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param f       WebIDL type: {@link PxQueryFlags} [Ref]
     * @return Stack allocated object of PxQueryFilterData
     */
    public static PxQueryFilterData createAt(long address, PxQueryFlags f) {
        __placement_new_PxQueryFilterData(address, f.getAddress());
        PxQueryFilterData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param f         WebIDL type: {@link PxQueryFlags} [Ref]
     * @return Stack allocated object of PxQueryFilterData
     */
    public static <T> PxQueryFilterData createAt(T allocator, Allocator<T> allocate, PxQueryFlags f) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxQueryFilterData(address, f.getAddress());
        PxQueryFilterData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxQueryFilterData(long address, long f);

    // Constructors

    public PxQueryFilterData() {
        address = _PxQueryFilterData();
    }
    private static native long _PxQueryFilterData();

    /**
     * @param fd WebIDL type: {@link PxFilterData} [Const, Ref]
     * @param f  WebIDL type: {@link PxQueryFlags} [Ref]
     */
    public PxQueryFilterData(PxFilterData fd, PxQueryFlags f) {
        address = _PxQueryFilterData(fd.getAddress(), f.getAddress());
    }
    private static native long _PxQueryFilterData(long fd, long f);

    /**
     * @param f WebIDL type: {@link PxQueryFlags} [Ref]
     */
    public PxQueryFilterData(PxQueryFlags f) {
        address = _PxQueryFilterData(f.getAddress());
    }
    private static native long _PxQueryFilterData(long f);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxFilterData} [Value]
     */
    public PxFilterData getData() {
        checkNotNull();
        return PxFilterData.wrapPointer(_getData(address));
    }
    private static native long _getData(long address);

    /**
     * @param value WebIDL type: {@link PxFilterData} [Value]
     */
    public void setData(PxFilterData value) {
        checkNotNull();
        _setData(address, value.getAddress());
    }
    private static native void _setData(long address, long value);

    /**
     * @return WebIDL type: {@link PxQueryFlags} [Value]
     */
    public PxQueryFlags getFlags() {
        checkNotNull();
        return PxQueryFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value WebIDL type: {@link PxQueryFlags} [Value]
     */
    public void setFlags(PxQueryFlags value) {
        checkNotNull();
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

}
