package physx.physics;

import physx.NativeObject;

public class PxQueryHit extends NativeObject {

    protected PxQueryHit() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxQueryHit wrapPointer(long address) {
        return address != 0L ? new PxQueryHit(address) : null;
    }
    
    public static PxQueryHit arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxQueryHit(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getFaceIndex() {
        checkNotNull();
        return _getFaceIndex(address);
    }
    private static native int _getFaceIndex(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setFaceIndex(int value) {
        checkNotNull();
        _setFaceIndex(address, value);
    }
    private static native void _setFaceIndex(long address, int value);

}
