package physx.physics;

import physx.common.PxTransform;

public class PxRigidActor extends PxActor {

    protected PxRigidActor() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxRigidActor wrapPointer(long address) {
        return address != 0L ? new PxRigidActor(address) : null;
    }
    
    public static PxRigidActor arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxRigidActor(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getGlobalPose() {
        checkNotNull();
        return PxTransform.wrapPointer(_getGlobalPose(address));
    }
    private static native long _getGlobalPose(long address);

    /**
     * @param pose WebIDL type: {@link PxTransform} [Const, Ref]
     */
    public void setGlobalPose(PxTransform pose) {
        checkNotNull();
        _setGlobalPose(address, pose.getAddress());
    }
    private static native void _setGlobalPose(long address, long pose);

    /**
     * @param pose     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param autowake WebIDL type: boolean
     */
    public void setGlobalPose(PxTransform pose, boolean autowake) {
        checkNotNull();
        _setGlobalPose(address, pose.getAddress(), autowake);
    }
    private static native void _setGlobalPose(long address, long pose, boolean autowake);

    /**
     * @param shape WebIDL type: {@link PxShape} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean attachShape(PxShape shape) {
        checkNotNull();
        return _attachShape(address, shape.getAddress());
    }
    private static native boolean _attachShape(long address, long shape);

    /**
     * @param shape WebIDL type: {@link PxShape} [Ref]
     */
    public void detachShape(PxShape shape) {
        checkNotNull();
        _detachShape(address, shape.getAddress());
    }
    private static native void _detachShape(long address, long shape);

    /**
     * @param shape           WebIDL type: {@link PxShape} [Ref]
     * @param wakeOnLostTouch WebIDL type: boolean
     */
    public void detachShape(PxShape shape, boolean wakeOnLostTouch) {
        checkNotNull();
        _detachShape(address, shape.getAddress(), wakeOnLostTouch);
    }
    private static native void _detachShape(long address, long shape, boolean wakeOnLostTouch);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbShapes() {
        checkNotNull();
        return _getNbShapes(address);
    }
    private static native int _getNbShapes(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbConstraints() {
        checkNotNull();
        return _getNbConstraints(address);
    }
    private static native int _getNbConstraints(long address);

}
