package physx.physics;

import physx.common.PxTransform;
import physx.common.PxVec3;

public class PxRigidBody extends PxRigidActor {

    protected PxRigidBody() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxRigidBody wrapPointer(long address) {
        return address != 0L ? new PxRigidBody(address) : null;
    }
    
    public static PxRigidBody arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxRigidBody(long address) {
        super(address);
    }

    // Functions

    /**
     * @param pose WebIDL type: {@link PxTransform} [Const, Ref]
     */
    public void setCMassLocalPose(PxTransform pose) {
        checkNotNull();
        _setCMassLocalPose(address, pose.getAddress());
    }
    private static native void _setCMassLocalPose(long address, long pose);

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getCMassLocalPose() {
        checkNotNull();
        return PxTransform.wrapPointer(_getCMassLocalPose(address));
    }
    private static native long _getCMassLocalPose(long address);

    /**
     * @param mass WebIDL type: float
     */
    public void setMass(float mass) {
        checkNotNull();
        _setMass(address, mass);
    }
    private static native void _setMass(long address, float mass);

    /**
     * @return WebIDL type: float
     */
    public float getMass() {
        checkNotNull();
        return _getMass(address);
    }
    private static native float _getMass(long address);

    /**
     * @return WebIDL type: float
     */
    public float getInvMass() {
        checkNotNull();
        return _getInvMass(address);
    }
    private static native float _getInvMass(long address);

    /**
     * @param m WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setMassSpaceInertiaTensor(PxVec3 m) {
        checkNotNull();
        _setMassSpaceInertiaTensor(address, m.getAddress());
    }
    private static native void _setMassSpaceInertiaTensor(long address, long m);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getMassSpaceInertiaTensor() {
        checkNotNull();
        return PxVec3.wrapPointer(_getMassSpaceInertiaTensor(address));
    }
    private static native long _getMassSpaceInertiaTensor(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getMassSpaceInvInertiaTensor() {
        checkNotNull();
        return PxVec3.wrapPointer(_getMassSpaceInvInertiaTensor(address));
    }
    private static native long _getMassSpaceInvInertiaTensor(long address);

    /**
     * @param linDamp WebIDL type: float
     */
    public void setLinearDamping(float linDamp) {
        checkNotNull();
        _setLinearDamping(address, linDamp);
    }
    private static native void _setLinearDamping(long address, float linDamp);

    /**
     * @return WebIDL type: float
     */
    public float getLinearDamping() {
        checkNotNull();
        return _getLinearDamping(address);
    }
    private static native float _getLinearDamping(long address);

    /**
     * @param angDamp WebIDL type: float
     */
    public void setAngularDamping(float angDamp) {
        checkNotNull();
        _setAngularDamping(address, angDamp);
    }
    private static native void _setAngularDamping(long address, float angDamp);

    /**
     * @return WebIDL type: float
     */
    public float getAngularDamping() {
        checkNotNull();
        return _getAngularDamping(address);
    }
    private static native float _getAngularDamping(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getLinearVelocity() {
        checkNotNull();
        return PxVec3.wrapPointer(_getLinearVelocity(address));
    }
    private static native long _getLinearVelocity(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getAngularVelocity() {
        checkNotNull();
        return PxVec3.wrapPointer(_getAngularVelocity(address));
    }
    private static native long _getAngularVelocity(long address);

    /**
     * @param maxLinVel WebIDL type: float
     */
    public void setMaxLinearVelocity(float maxLinVel) {
        checkNotNull();
        _setMaxLinearVelocity(address, maxLinVel);
    }
    private static native void _setMaxLinearVelocity(long address, float maxLinVel);

    /**
     * @return WebIDL type: float
     */
    public float getMaxLinearVelocity() {
        checkNotNull();
        return _getMaxLinearVelocity(address);
    }
    private static native float _getMaxLinearVelocity(long address);

    /**
     * @param maxAngVel WebIDL type: float
     */
    public void setMaxAngularVelocity(float maxAngVel) {
        checkNotNull();
        _setMaxAngularVelocity(address, maxAngVel);
    }
    private static native void _setMaxAngularVelocity(long address, float maxAngVel);

    /**
     * @return WebIDL type: float
     */
    public float getMaxAngularVelocity() {
        checkNotNull();
        return _getMaxAngularVelocity(address);
    }
    private static native float _getMaxAngularVelocity(long address);

    /**
     * @param force WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void addForce(PxVec3 force) {
        checkNotNull();
        _addForce(address, force.getAddress());
    }
    private static native void _addForce(long address, long force);

    /**
     * @param force WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode  WebIDL type: {@link PxForceModeEnum} [enum]
     */
    public void addForce(PxVec3 force, PxForceModeEnum mode) {
        checkNotNull();
        _addForce(address, force.getAddress(), mode.value);
    }
    private static native void _addForce(long address, long force, int mode);

    /**
     * @param force    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode     WebIDL type: {@link PxForceModeEnum} [enum]
     * @param autowake WebIDL type: boolean
     */
    public void addForce(PxVec3 force, PxForceModeEnum mode, boolean autowake) {
        checkNotNull();
        _addForce(address, force.getAddress(), mode.value, autowake);
    }
    private static native void _addForce(long address, long force, int mode, boolean autowake);

    /**
     * @param torque WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void addTorque(PxVec3 torque) {
        checkNotNull();
        _addTorque(address, torque.getAddress());
    }
    private static native void _addTorque(long address, long torque);

    /**
     * @param torque WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode   WebIDL type: {@link PxForceModeEnum} [enum]
     */
    public void addTorque(PxVec3 torque, PxForceModeEnum mode) {
        checkNotNull();
        _addTorque(address, torque.getAddress(), mode.value);
    }
    private static native void _addTorque(long address, long torque, int mode);

    /**
     * @param torque   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode     WebIDL type: {@link PxForceModeEnum} [enum]
     * @param autowake WebIDL type: boolean
     */
    public void addTorque(PxVec3 torque, PxForceModeEnum mode, boolean autowake) {
        checkNotNull();
        _addTorque(address, torque.getAddress(), mode.value, autowake);
    }
    private static native void _addTorque(long address, long torque, int mode, boolean autowake);

    /**
     * @param mode WebIDL type: {@link PxForceModeEnum} [enum]
     */
    public void clearForce(PxForceModeEnum mode) {
        checkNotNull();
        _clearForce(address, mode.value);
    }
    private static native void _clearForce(long address, int mode);

    /**
     * @param mode WebIDL type: {@link PxForceModeEnum} [enum]
     */
    public void clearTorque(PxForceModeEnum mode) {
        checkNotNull();
        _clearTorque(address, mode.value);
    }
    private static native void _clearTorque(long address, int mode);

    /**
     * @param force  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param torque WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setForceAndTorque(PxVec3 force, PxVec3 torque) {
        checkNotNull();
        _setForceAndTorque(address, force.getAddress(), torque.getAddress());
    }
    private static native void _setForceAndTorque(long address, long force, long torque);

    /**
     * @param force  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param torque WebIDL type: {@link PxVec3} [Const, Ref]
     * @param mode   WebIDL type: {@link PxForceModeEnum} [enum]
     */
    public void setForceAndTorque(PxVec3 force, PxVec3 torque, PxForceModeEnum mode) {
        checkNotNull();
        _setForceAndTorque(address, force.getAddress(), torque.getAddress(), mode.value);
    }
    private static native void _setForceAndTorque(long address, long force, long torque, int mode);

    /**
     * @param flag  WebIDL type: {@link PxRigidBodyFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setRigidBodyFlag(PxRigidBodyFlagEnum flag, boolean value) {
        checkNotNull();
        _setRigidBodyFlag(address, flag.value, value);
    }
    private static native void _setRigidBodyFlag(long address, int flag, boolean value);

    /**
     * @param inFlags WebIDL type: {@link PxRigidBodyFlags} [Ref]
     */
    public void setRigidBodyFlags(PxRigidBodyFlags inFlags) {
        checkNotNull();
        _setRigidBodyFlags(address, inFlags.getAddress());
    }
    private static native void _setRigidBodyFlags(long address, long inFlags);

    /**
     * @return WebIDL type: {@link PxRigidBodyFlags} [Value]
     */
    public PxRigidBodyFlags getRigidBodyFlags() {
        checkNotNull();
        return PxRigidBodyFlags.wrapPointer(_getRigidBodyFlags(address));
    }
    private static native long _getRigidBodyFlags(long address);

    /**
     * @param advanceCoefficient WebIDL type: float
     */
    public void setMinCCDAdvanceCoefficient(float advanceCoefficient) {
        checkNotNull();
        _setMinCCDAdvanceCoefficient(address, advanceCoefficient);
    }
    private static native void _setMinCCDAdvanceCoefficient(long address, float advanceCoefficient);

    /**
     * @return WebIDL type: float
     */
    public float getMinCCDAdvanceCoefficient() {
        checkNotNull();
        return _getMinCCDAdvanceCoefficient(address);
    }
    private static native float _getMinCCDAdvanceCoefficient(long address);

    /**
     * @param biasClamp WebIDL type: float
     */
    public void setMaxDepenetrationVelocity(float biasClamp) {
        checkNotNull();
        _setMaxDepenetrationVelocity(address, biasClamp);
    }
    private static native void _setMaxDepenetrationVelocity(long address, float biasClamp);

    /**
     * @return WebIDL type: float
     */
    public float getMaxDepenetrationVelocity() {
        checkNotNull();
        return _getMaxDepenetrationVelocity(address);
    }
    private static native float _getMaxDepenetrationVelocity(long address);

    /**
     * @param maxImpulse WebIDL type: float
     */
    public void setMaxContactImpulse(float maxImpulse) {
        checkNotNull();
        _setMaxContactImpulse(address, maxImpulse);
    }
    private static native void _setMaxContactImpulse(long address, float maxImpulse);

    /**
     * @return WebIDL type: float
     */
    public float getMaxContactImpulse() {
        checkNotNull();
        return _getMaxContactImpulse(address);
    }
    private static native float _getMaxContactImpulse(long address);

    /**
     * @param slopCoefficient WebIDL type: float
     */
    public void setContactSlopCoefficient(float slopCoefficient) {
        checkNotNull();
        _setContactSlopCoefficient(address, slopCoefficient);
    }
    private static native void _setContactSlopCoefficient(long address, float slopCoefficient);

    /**
     * @return WebIDL type: float
     */
    public float getContactSlopCoefficient() {
        checkNotNull();
        return _getContactSlopCoefficient(address);
    }
    private static native float _getContactSlopCoefficient(long address);

}
