package physx.physics;

import physx.common.PxTransform;
import physx.common.PxVec3;

public class PxRigidDynamic extends PxRigidBody {

    protected PxRigidDynamic() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxRigidDynamic wrapPointer(long address) {
        return address != 0L ? new PxRigidDynamic(address) : null;
    }
    
    public static PxRigidDynamic arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxRigidDynamic(long address) {
        super(address);
    }

    // Functions

    /**
     * @param destination WebIDL type: {@link PxTransform} [Const, Ref]
     */
    public void setKinematicTarget(PxTransform destination) {
        checkNotNull();
        _setKinematicTarget(address, destination.getAddress());
    }
    private static native void _setKinematicTarget(long address, long destination);

    /**
     * @param target WebIDL type: {@link PxTransform} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean getKinematicTarget(PxTransform target) {
        checkNotNull();
        return _getKinematicTarget(address, target.getAddress());
    }
    private static native boolean _getKinematicTarget(long address, long target);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isSleeping() {
        checkNotNull();
        return _isSleeping(address);
    }
    private static native boolean _isSleeping(long address);

    /**
     * @param threshold WebIDL type: float
     */
    public void setSleepThreshold(float threshold) {
        checkNotNull();
        _setSleepThreshold(address, threshold);
    }
    private static native void _setSleepThreshold(long address, float threshold);

    /**
     * @return WebIDL type: float
     */
    public float getSleepThreshold() {
        checkNotNull();
        return _getSleepThreshold(address);
    }
    private static native float _getSleepThreshold(long address);

    /**
     * @param threshold WebIDL type: float
     */
    public void setStabilizationThreshold(float threshold) {
        checkNotNull();
        _setStabilizationThreshold(address, threshold);
    }
    private static native void _setStabilizationThreshold(long address, float threshold);

    /**
     * @return WebIDL type: float
     */
    public float getStabilizationThreshold() {
        checkNotNull();
        return _getStabilizationThreshold(address);
    }
    private static native float _getStabilizationThreshold(long address);

    /**
     * @return WebIDL type: {@link PxRigidDynamicLockFlags} [Value]
     */
    public PxRigidDynamicLockFlags getRigidDynamicLockFlags() {
        checkNotNull();
        return PxRigidDynamicLockFlags.wrapPointer(_getRigidDynamicLockFlags(address));
    }
    private static native long _getRigidDynamicLockFlags(long address);

    /**
     * @param flag  WebIDL type: {@link PxRigidDynamicLockFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setRigidDynamicLockFlag(PxRigidDynamicLockFlagEnum flag, boolean value) {
        checkNotNull();
        _setRigidDynamicLockFlag(address, flag.value, value);
    }
    private static native void _setRigidDynamicLockFlag(long address, int flag, boolean value);

    /**
     * @param flags WebIDL type: {@link PxRigidDynamicLockFlags} [Ref]
     */
    public void setRigidDynamicLockFlags(PxRigidDynamicLockFlags flags) {
        checkNotNull();
        _setRigidDynamicLockFlags(address, flags.getAddress());
    }
    private static native void _setRigidDynamicLockFlags(long address, long flags);

    /**
     * @param linVel WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setLinearVelocity(PxVec3 linVel) {
        checkNotNull();
        _setLinearVelocity(address, linVel.getAddress());
    }
    private static native void _setLinearVelocity(long address, long linVel);

    /**
     * @param linVel   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param autowake WebIDL type: boolean
     */
    public void setLinearVelocity(PxVec3 linVel, boolean autowake) {
        checkNotNull();
        _setLinearVelocity(address, linVel.getAddress(), autowake);
    }
    private static native void _setLinearVelocity(long address, long linVel, boolean autowake);

    /**
     * @param angVel WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setAngularVelocity(PxVec3 angVel) {
        checkNotNull();
        _setAngularVelocity(address, angVel.getAddress());
    }
    private static native void _setAngularVelocity(long address, long angVel);

    /**
     * @param angVel   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param autowake WebIDL type: boolean
     */
    public void setAngularVelocity(PxVec3 angVel, boolean autowake) {
        checkNotNull();
        _setAngularVelocity(address, angVel.getAddress(), autowake);
    }
    private static native void _setAngularVelocity(long address, long angVel, boolean autowake);

    /**
     * @param wakeCounterValue WebIDL type: float
     */
    public void setWakeCounter(float wakeCounterValue) {
        checkNotNull();
        _setWakeCounter(address, wakeCounterValue);
    }
    private static native void _setWakeCounter(long address, float wakeCounterValue);

    /**
     * @return WebIDL type: float
     */
    public float getWakeCounter() {
        checkNotNull();
        return _getWakeCounter(address);
    }
    private static native float _getWakeCounter(long address);

    public void wakeUp() {
        checkNotNull();
        _wakeUp(address);
    }
    private static native void _wakeUp(long address);

    public void putToSleep() {
        checkNotNull();
        _putToSleep(address);
    }
    private static native void _putToSleep(long address);

    /**
     * @param minPositionIters WebIDL type: unsigned long
     */
    public void setSolverIterationCounts(int minPositionIters) {
        checkNotNull();
        _setSolverIterationCounts(address, minPositionIters);
    }
    private static native void _setSolverIterationCounts(long address, int minPositionIters);

    /**
     * @param minPositionIters WebIDL type: unsigned long
     * @param minVelocityIters WebIDL type: unsigned long
     */
    public void setSolverIterationCounts(int minPositionIters, int minVelocityIters) {
        checkNotNull();
        _setSolverIterationCounts(address, minPositionIters, minVelocityIters);
    }
    private static native void _setSolverIterationCounts(long address, int minPositionIters, int minVelocityIters);

    /**
     * @return WebIDL type: float
     */
    public float getContactReportThreshold() {
        checkNotNull();
        return _getContactReportThreshold(address);
    }
    private static native float _getContactReportThreshold(long address);

    /**
     * @param threshold WebIDL type: float
     */
    public void setContactReportThreshold(float threshold) {
        checkNotNull();
        _setContactReportThreshold(address, threshold);
    }
    private static native void _setContactReportThreshold(long address, float threshold);

}
