package physx.physics;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxBaseTask;
import physx.common.PxBounds3;
import physx.common.PxCollection;
import physx.common.PxCpuDispatcher;
import physx.common.PxCudaContextManager;
import physx.common.PxRenderBuffer;
import physx.common.PxVec3;
import physx.geometry.PxBVH;
import physx.particles.PxParticleSolverTypeEnum;
import physx.support.PxVisualizationParameterEnum;

public class PxScene extends PxSceneSQSystem {

    protected PxScene() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxScene wrapPointer(long address) {
        return address != 0L ? new PxScene(address) : null;
    }
    
    public static PxScene arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxScene(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getUserData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getUserData(address));
    }
    private static native long _getUserData(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setUserData(NativeObject value) {
        checkNotNull();
        _setUserData(address, value.getAddress());
    }
    private static native void _setUserData(long address, long value);

    // Functions

    /**
     * @param actor WebIDL type: {@link PxActor} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean addActor(PxActor actor) {
        checkNotNull();
        return _addActor(address, actor.getAddress());
    }
    private static native boolean _addActor(long address, long actor);

    /**
     * @param actor WebIDL type: {@link PxActor} [Ref]
     * @param bvh   WebIDL type: {@link PxBVH} [Const]
     * @return WebIDL type: boolean
     */
    public boolean addActor(PxActor actor, PxBVH bvh) {
        checkNotNull();
        return _addActor(address, actor.getAddress(), bvh.getAddress());
    }
    private static native boolean _addActor(long address, long actor, long bvh);

    /**
     * @param actor WebIDL type: {@link PxActor} [Ref]
     */
    public void removeActor(PxActor actor) {
        checkNotNull();
        _removeActor(address, actor.getAddress());
    }
    private static native void _removeActor(long address, long actor);

    /**
     * @param actor           WebIDL type: {@link PxActor} [Ref]
     * @param wakeOnLostTouch WebIDL type: boolean
     */
    public void removeActor(PxActor actor, boolean wakeOnLostTouch) {
        checkNotNull();
        _removeActor(address, actor.getAddress(), wakeOnLostTouch);
    }
    private static native void _removeActor(long address, long actor, boolean wakeOnLostTouch);

    /**
     * @param aggregate WebIDL type: {@link PxAggregate} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean addAggregate(PxAggregate aggregate) {
        checkNotNull();
        return _addAggregate(address, aggregate.getAddress());
    }
    private static native boolean _addAggregate(long address, long aggregate);

    /**
     * @param aggregate WebIDL type: {@link PxAggregate} [Ref]
     */
    public void removeAggregate(PxAggregate aggregate) {
        checkNotNull();
        _removeAggregate(address, aggregate.getAddress());
    }
    private static native void _removeAggregate(long address, long aggregate);

    /**
     * @param aggregate       WebIDL type: {@link PxAggregate} [Ref]
     * @param wakeOnLostTouch WebIDL type: boolean
     */
    public void removeAggregate(PxAggregate aggregate, boolean wakeOnLostTouch) {
        checkNotNull();
        _removeAggregate(address, aggregate.getAddress(), wakeOnLostTouch);
    }
    private static native void _removeAggregate(long address, long aggregate, boolean wakeOnLostTouch);

    /**
     * @param collection WebIDL type: {@link PxCollection} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean addCollection(PxCollection collection) {
        checkNotNull();
        return _addCollection(address, collection.getAddress());
    }
    private static native boolean _addCollection(long address, long collection);

    /**
     * @return WebIDL type: float
     */
    public float getWakeCounterResetValue() {
        checkNotNull();
        return _getWakeCounterResetValue(address);
    }
    private static native float _getWakeCounterResetValue(long address);

    /**
     * @param shift WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void shiftOrigin(PxVec3 shift) {
        checkNotNull();
        _shiftOrigin(address, shift.getAddress());
    }
    private static native void _shiftOrigin(long address, long shift);

    /**
     * @param articulation WebIDL type: {@link PxArticulationReducedCoordinate} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean addArticulation(PxArticulationReducedCoordinate articulation) {
        checkNotNull();
        return _addArticulation(address, articulation.getAddress());
    }
    private static native boolean _addArticulation(long address, long articulation);

    /**
     * @param articulation WebIDL type: {@link PxArticulationReducedCoordinate} [Ref]
     */
    public void removeArticulation(PxArticulationReducedCoordinate articulation) {
        checkNotNull();
        _removeArticulation(address, articulation.getAddress());
    }
    private static native void _removeArticulation(long address, long articulation);

    /**
     * @param articulation    WebIDL type: {@link PxArticulationReducedCoordinate} [Ref]
     * @param wakeOnLostTouch WebIDL type: boolean
     */
    public void removeArticulation(PxArticulationReducedCoordinate articulation, boolean wakeOnLostTouch) {
        checkNotNull();
        _removeArticulation(address, articulation.getAddress(), wakeOnLostTouch);
    }
    private static native void _removeArticulation(long address, long articulation, boolean wakeOnLostTouch);

    /**
     * @param types WebIDL type: {@link PxActorTypeFlags} [Ref]
     * @return WebIDL type: unsigned long
     */
    public int getNbActors(PxActorTypeFlags types) {
        checkNotNull();
        return _getNbActors(address, types.getAddress());
    }
    private static native int _getNbActors(long address, long types);

    /**
     * @return WebIDL type: unsigned long [Platforms=windows;linux, Value]
     */
    public int getNbSoftBodies() {
        checkNotNull();
        PlatformChecks.requirePlatform(3, "physx.physics.PxScene");
        return _getNbSoftBodies(address);
    }
    private static native int _getNbSoftBodies(long address);

    /**
     * @param type WebIDL type: {@link PxParticleSolverTypeEnum} [enum]
     * @return WebIDL type: unsigned long [Platforms=windows;linux, Value]
     */
    public int getNbParticleSystems(PxParticleSolverTypeEnum type) {
        checkNotNull();
        PlatformChecks.requirePlatform(3, "physx.physics.PxScene");
        return _getNbParticleSystems(address, type.value);
    }
    private static native int _getNbParticleSystems(long address, int type);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbArticulations() {
        checkNotNull();
        return _getNbArticulations(address);
    }
    private static native int _getNbArticulations(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbConstraints() {
        checkNotNull();
        return _getNbConstraints(address);
    }
    private static native int _getNbConstraints(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbAggregates() {
        checkNotNull();
        return _getNbAggregates(address);
    }
    private static native int _getNbAggregates(long address);

    /**
     * @param group1    WebIDL type: octet
     * @param group2    WebIDL type: octet
     * @param dominance WebIDL type: {@link PxDominanceGroupPair} [Const, Ref]
     */
    public void setDominanceGroupPair(byte group1, byte group2, PxDominanceGroupPair dominance) {
        checkNotNull();
        _setDominanceGroupPair(address, group1, group2, dominance.getAddress());
    }
    private static native void _setDominanceGroupPair(long address, byte group1, byte group2, long dominance);

    /**
     * @param group1 WebIDL type: octet
     * @param group2 WebIDL type: octet
     * @return WebIDL type: {@link PxDominanceGroupPair} [Platforms=windows;linux, Value]
     */
    public PxDominanceGroupPair getDominanceGroupPair(byte group1, byte group2) {
        checkNotNull();
        PlatformChecks.requirePlatform(3, "physx.physics.PxScene");
        return PxDominanceGroupPair.wrapPointer(_getDominanceGroupPair(address, group1, group2));
    }
    private static native long _getDominanceGroupPair(long address, byte group1, byte group2);

    /**
     * @return WebIDL type: {@link PxCpuDispatcher}
     */
    public PxCpuDispatcher getCpuDispatcher() {
        checkNotNull();
        return PxCpuDispatcher.wrapPointer(_getCpuDispatcher(address));
    }
    private static native long _getCpuDispatcher(long address);

    /**
     * @return WebIDL type: {@link PxCudaContextManager} [Platforms=windows;linux]
     */
    public PxCudaContextManager getCudaContextManager() {
        checkNotNull();
        PlatformChecks.requirePlatform(3, "physx.physics.PxScene");
        return PxCudaContextManager.wrapPointer(_getCudaContextManager(address));
    }
    private static native long _getCudaContextManager(long address);

    /**
     * @return WebIDL type: octet
     */
    public byte createClient() {
        checkNotNull();
        return _createClient(address);
    }
    private static native byte _createClient(long address);

    /**
     * @param callback WebIDL type: {@link PxSimulationEventCallback}
     */
    public void setSimulationEventCallback(PxSimulationEventCallback callback) {
        checkNotNull();
        _setSimulationEventCallback(address, callback.getAddress());
    }
    private static native void _setSimulationEventCallback(long address, long callback);

    /**
     * @return WebIDL type: {@link PxSimulationEventCallback}
     */
    public PxSimulationEventCallback getSimulationEventCallback() {
        checkNotNull();
        return PxSimulationEventCallback.wrapPointer(_getSimulationEventCallback(address));
    }
    private static native long _getSimulationEventCallback(long address);

    /**
     * @param data     WebIDL type: VoidPtr [Const]
     * @param dataSize WebIDL type: unsigned long
     */
    public void setFilterShaderData(NativeObject data, int dataSize) {
        checkNotNull();
        _setFilterShaderData(address, data.getAddress(), dataSize);
    }
    private static native void _setFilterShaderData(long address, long data, int dataSize);

    /**
     * @return WebIDL type: VoidPtr [Const]
     */
    public NativeObject getFilterShaderData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getFilterShaderData(address));
    }
    private static native long _getFilterShaderData(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getFilterShaderDataSize() {
        checkNotNull();
        return _getFilterShaderDataSize(address);
    }
    private static native int _getFilterShaderDataSize(long address);

    /**
     * @return WebIDL type: {@link PxSimulationFilterShader} [Value]
     */
    public PxSimulationFilterShader getFilterShader() {
        checkNotNull();
        return PxSimulationFilterShader.wrapPointer(_getFilterShader(address));
    }
    private static native long _getFilterShader(long address);

    /**
     * @param actor WebIDL type: {@link PxActor} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean resetFiltering(PxActor actor) {
        checkNotNull();
        return _resetFiltering(address, actor.getAddress());
    }
    private static native boolean _resetFiltering(long address, long actor);

    /**
     * @return WebIDL type: {@link PxPairFilteringModeEnum} [enum]
     */
    public PxPairFilteringModeEnum getKinematicKinematicFilteringMode() {
        checkNotNull();
        return PxPairFilteringModeEnum.forValue(_getKinematicKinematicFilteringMode(address));
    }
    private static native int _getKinematicKinematicFilteringMode(long address);

    /**
     * @return WebIDL type: {@link PxPairFilteringModeEnum} [enum]
     */
    public PxPairFilteringModeEnum getStaticKinematicFilteringMode() {
        checkNotNull();
        return PxPairFilteringModeEnum.forValue(_getStaticKinematicFilteringMode(address));
    }
    private static native int _getStaticKinematicFilteringMode(long address);

    /**
     * @param elapsedTime WebIDL type: float
     * @return WebIDL type: boolean
     */
    public boolean simulate(float elapsedTime) {
        checkNotNull();
        return _simulate(address, elapsedTime);
    }
    private static native boolean _simulate(long address, float elapsedTime);

    /**
     * @param elapsedTime    WebIDL type: float
     * @param completionTask WebIDL type: {@link PxBaseTask}
     * @return WebIDL type: boolean
     */
    public boolean simulate(float elapsedTime, PxBaseTask completionTask) {
        checkNotNull();
        return _simulate(address, elapsedTime, completionTask.getAddress());
    }
    private static native boolean _simulate(long address, float elapsedTime, long completionTask);

    /**
     * @param elapsedTime     WebIDL type: float
     * @param completionTask  WebIDL type: {@link PxBaseTask}
     * @param scratchMemBlock WebIDL type: VoidPtr
     * @return WebIDL type: boolean
     */
    public boolean simulate(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock) {
        checkNotNull();
        return _simulate(address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress());
    }
    private static native boolean _simulate(long address, float elapsedTime, long completionTask, long scratchMemBlock);

    /**
     * @param elapsedTime         WebIDL type: float
     * @param completionTask      WebIDL type: {@link PxBaseTask}
     * @param scratchMemBlock     WebIDL type: VoidPtr
     * @param scratchMemBlockSize WebIDL type: unsigned long
     * @return WebIDL type: boolean
     */
    public boolean simulate(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock, int scratchMemBlockSize) {
        checkNotNull();
        return _simulate(address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress(), scratchMemBlockSize);
    }
    private static native boolean _simulate(long address, float elapsedTime, long completionTask, long scratchMemBlock, int scratchMemBlockSize);

    /**
     * @param elapsedTime         WebIDL type: float
     * @param completionTask      WebIDL type: {@link PxBaseTask}
     * @param scratchMemBlock     WebIDL type: VoidPtr
     * @param scratchMemBlockSize WebIDL type: unsigned long
     * @param controlSimulation   WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public boolean simulate(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock, int scratchMemBlockSize, boolean controlSimulation) {
        checkNotNull();
        return _simulate(address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress(), scratchMemBlockSize, controlSimulation);
    }
    private static native boolean _simulate(long address, float elapsedTime, long completionTask, long scratchMemBlock, int scratchMemBlockSize, boolean controlSimulation);

    /**
     * @return WebIDL type: boolean
     */
    public boolean advance() {
        checkNotNull();
        return _advance(address);
    }
    private static native boolean _advance(long address);

    /**
     * @param completionTask WebIDL type: {@link PxBaseTask}
     * @return WebIDL type: boolean
     */
    public boolean advance(PxBaseTask completionTask) {
        checkNotNull();
        return _advance(address, completionTask.getAddress());
    }
    private static native boolean _advance(long address, long completionTask);

    /**
     * @param elapsedTime WebIDL type: float
     * @return WebIDL type: boolean
     */
    public boolean collide(float elapsedTime) {
        checkNotNull();
        return _collide(address, elapsedTime);
    }
    private static native boolean _collide(long address, float elapsedTime);

    /**
     * @param elapsedTime    WebIDL type: float
     * @param completionTask WebIDL type: {@link PxBaseTask}
     * @return WebIDL type: boolean
     */
    public boolean collide(float elapsedTime, PxBaseTask completionTask) {
        checkNotNull();
        return _collide(address, elapsedTime, completionTask.getAddress());
    }
    private static native boolean _collide(long address, float elapsedTime, long completionTask);

    /**
     * @param elapsedTime     WebIDL type: float
     * @param completionTask  WebIDL type: {@link PxBaseTask}
     * @param scratchMemBlock WebIDL type: VoidPtr
     * @return WebIDL type: boolean
     */
    public boolean collide(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock) {
        checkNotNull();
        return _collide(address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress());
    }
    private static native boolean _collide(long address, float elapsedTime, long completionTask, long scratchMemBlock);

    /**
     * @param elapsedTime         WebIDL type: float
     * @param completionTask      WebIDL type: {@link PxBaseTask}
     * @param scratchMemBlock     WebIDL type: VoidPtr
     * @param scratchMemBlockSize WebIDL type: unsigned long
     * @return WebIDL type: boolean
     */
    public boolean collide(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock, int scratchMemBlockSize) {
        checkNotNull();
        return _collide(address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress(), scratchMemBlockSize);
    }
    private static native boolean _collide(long address, float elapsedTime, long completionTask, long scratchMemBlock, int scratchMemBlockSize);

    /**
     * @param elapsedTime         WebIDL type: float
     * @param completionTask      WebIDL type: {@link PxBaseTask}
     * @param scratchMemBlock     WebIDL type: VoidPtr
     * @param scratchMemBlockSize WebIDL type: unsigned long
     * @param controlSimulation   WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public boolean collide(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock, int scratchMemBlockSize, boolean controlSimulation) {
        checkNotNull();
        return _collide(address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress(), scratchMemBlockSize, controlSimulation);
    }
    private static native boolean _collide(long address, float elapsedTime, long completionTask, long scratchMemBlock, int scratchMemBlockSize, boolean controlSimulation);

    /**
     * @return WebIDL type: boolean
     */
    public boolean checkResults() {
        checkNotNull();
        return _checkResults(address);
    }
    private static native boolean _checkResults(long address);

    /**
     * @param block WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public boolean checkResults(boolean block) {
        checkNotNull();
        return _checkResults(address, block);
    }
    private static native boolean _checkResults(long address, boolean block);

    /**
     * @return WebIDL type: boolean
     */
    public boolean fetchCollision() {
        checkNotNull();
        return _fetchCollision(address);
    }
    private static native boolean _fetchCollision(long address);

    /**
     * @param block WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public boolean fetchCollision(boolean block) {
        checkNotNull();
        return _fetchCollision(address, block);
    }
    private static native boolean _fetchCollision(long address, boolean block);

    /**
     * @return WebIDL type: boolean
     */
    public boolean fetchResults() {
        checkNotNull();
        return _fetchResults(address);
    }
    private static native boolean _fetchResults(long address);

    /**
     * @param block WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public boolean fetchResults(boolean block) {
        checkNotNull();
        return _fetchResults(address, block);
    }
    private static native boolean _fetchResults(long address, boolean block);

    /**
     * @param continuation WebIDL type: {@link PxBaseTask}
     */
    public void processCallbacks(PxBaseTask continuation) {
        checkNotNull();
        _processCallbacks(address, continuation.getAddress());
    }
    private static native void _processCallbacks(long address, long continuation);

    public void fetchResultsParticleSystem() {
        checkNotNull();
        _fetchResultsParticleSystem(address);
    }
    private static native void _fetchResultsParticleSystem(long address);

    public void flushSimulation() {
        checkNotNull();
        _flushSimulation(address);
    }
    private static native void _flushSimulation(long address);

    /**
     * @param sendPendingReports WebIDL type: boolean
     */
    public void flushSimulation(boolean sendPendingReports) {
        checkNotNull();
        _flushSimulation(address, sendPendingReports);
    }
    private static native void _flushSimulation(long address, boolean sendPendingReports);

    /**
     * @param vec WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setGravity(PxVec3 vec) {
        checkNotNull();
        _setGravity(address, vec.getAddress());
    }
    private static native void _setGravity(long address, long vec);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getGravity() {
        checkNotNull();
        return PxVec3.wrapPointer(_getGravity(address));
    }
    private static native long _getGravity(long address);

    /**
     * @param t WebIDL type: float
     */
    public void setBounceThresholdVelocity(float t) {
        checkNotNull();
        _setBounceThresholdVelocity(address, t);
    }
    private static native void _setBounceThresholdVelocity(long address, float t);

    /**
     * @return WebIDL type: float
     */
    public float getBounceThresholdVelocity() {
        checkNotNull();
        return _getBounceThresholdVelocity(address);
    }
    private static native float _getBounceThresholdVelocity(long address);

    /**
     * @param ccdMaxPasses WebIDL type: unsigned long
     */
    public void setCCDMaxPasses(int ccdMaxPasses) {
        checkNotNull();
        _setCCDMaxPasses(address, ccdMaxPasses);
    }
    private static native void _setCCDMaxPasses(long address, int ccdMaxPasses);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getCCDMaxPasses() {
        checkNotNull();
        return _getCCDMaxPasses(address);
    }
    private static native int _getCCDMaxPasses(long address);

    /**
     * @param t WebIDL type: float
     */
    public void setCCDMaxSeparation(float t) {
        checkNotNull();
        _setCCDMaxSeparation(address, t);
    }
    private static native void _setCCDMaxSeparation(long address, float t);

    /**
     * @return WebIDL type: float
     */
    public float getCCDMaxSeparation() {
        checkNotNull();
        return _getCCDMaxSeparation(address);
    }
    private static native float _getCCDMaxSeparation(long address);

    /**
     * @param t WebIDL type: float
     */
    public void setCCDThreshold(float t) {
        checkNotNull();
        _setCCDThreshold(address, t);
    }
    private static native void _setCCDThreshold(long address, float t);

    /**
     * @return WebIDL type: float
     */
    public float getCCDThreshold() {
        checkNotNull();
        return _getCCDThreshold(address);
    }
    private static native float _getCCDThreshold(long address);

    /**
     * @param t WebIDL type: float
     */
    public void setMaxBiasCoefficient(float t) {
        checkNotNull();
        _setMaxBiasCoefficient(address, t);
    }
    private static native void _setMaxBiasCoefficient(long address, float t);

    /**
     * @return WebIDL type: float
     */
    public float getMaxBiasCoefficient() {
        checkNotNull();
        return _getMaxBiasCoefficient(address);
    }
    private static native float _getMaxBiasCoefficient(long address);

    /**
     * @param t WebIDL type: float
     */
    public void setFrictionOffsetThreshold(float t) {
        checkNotNull();
        _setFrictionOffsetThreshold(address, t);
    }
    private static native void _setFrictionOffsetThreshold(long address, float t);

    /**
     * @return WebIDL type: float
     */
    public float getFrictionOffsetThreshold() {
        checkNotNull();
        return _getFrictionOffsetThreshold(address);
    }
    private static native float _getFrictionOffsetThreshold(long address);

    /**
     * @param t WebIDL type: float
     */
    public void setFrictionCorrelationDistance(float t) {
        checkNotNull();
        _setFrictionCorrelationDistance(address, t);
    }
    private static native void _setFrictionCorrelationDistance(long address, float t);

    /**
     * @return WebIDL type: float
     */
    public float getFrictionCorrelationDistance() {
        checkNotNull();
        return _getFrictionCorrelationDistance(address);
    }
    private static native float _getFrictionCorrelationDistance(long address);

    /**
     * @return WebIDL type: {@link PxFrictionTypeEnum} [enum]
     */
    public PxFrictionTypeEnum getFrictionType() {
        checkNotNull();
        return PxFrictionTypeEnum.forValue(_getFrictionType(address));
    }
    private static native int _getFrictionType(long address);

    /**
     * @return WebIDL type: {@link PxSolverTypeEnum} [enum]
     */
    public PxSolverTypeEnum getSolverType() {
        checkNotNull();
        return PxSolverTypeEnum.forValue(_getSolverType(address));
    }
    private static native int _getSolverType(long address);

    /**
     * @return WebIDL type: {@link PxRenderBuffer} [Const, Ref]
     */
    public PxRenderBuffer getRenderBuffer() {
        checkNotNull();
        return PxRenderBuffer.wrapPointer(_getRenderBuffer(address));
    }
    private static native long _getRenderBuffer(long address);

    /**
     * @param param WebIDL type: {@link PxVisualizationParameterEnum} [enum]
     * @param value WebIDL type: float
     * @return WebIDL type: boolean
     */
    public boolean setVisualizationParameter(PxVisualizationParameterEnum param, float value) {
        checkNotNull();
        return _setVisualizationParameter(address, param.value, value);
    }
    private static native boolean _setVisualizationParameter(long address, int param, float value);

    /**
     * @param paramEnum WebIDL type: {@link PxVisualizationParameterEnum} [enum]
     * @return WebIDL type: float
     */
    public float getVisualizationParameter(PxVisualizationParameterEnum paramEnum) {
        checkNotNull();
        return _getVisualizationParameter(address, paramEnum.value);
    }
    private static native float _getVisualizationParameter(long address, int paramEnum);

    /**
     * @param box WebIDL type: {@link PxBounds3} [Const, Ref]
     */
    public void setVisualizationCullingBox(PxBounds3 box) {
        checkNotNull();
        _setVisualizationCullingBox(address, box.getAddress());
    }
    private static native void _setVisualizationCullingBox(long address, long box);

    /**
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public PxBounds3 getVisualizationCullingBox() {
        checkNotNull();
        return PxBounds3.wrapPointer(_getVisualizationCullingBox(address));
    }
    private static native long _getVisualizationCullingBox(long address);

    /**
     * @param stats WebIDL type: {@link PxSimulationStatistics} [Ref]
     */
    public void getSimulationStatistics(PxSimulationStatistics stats) {
        checkNotNull();
        _getSimulationStatistics(address, stats.getAddress());
    }
    private static native void _getSimulationStatistics(long address, long stats);

    /**
     * @return WebIDL type: {@link PxBroadPhaseTypeEnum} [enum]
     */
    public PxBroadPhaseTypeEnum getBroadPhaseType() {
        checkNotNull();
        return PxBroadPhaseTypeEnum.forValue(_getBroadPhaseType(address));
    }
    private static native int _getBroadPhaseType(long address);

    /**
     * @param caps WebIDL type: {@link PxBroadPhaseCaps} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean getBroadPhaseCaps(PxBroadPhaseCaps caps) {
        checkNotNull();
        return _getBroadPhaseCaps(address, caps.getAddress());
    }
    private static native boolean _getBroadPhaseCaps(long address, long caps);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbBroadPhaseRegions() {
        checkNotNull();
        return _getNbBroadPhaseRegions(address);
    }
    private static native int _getNbBroadPhaseRegions(long address);

    /**
     * @param userBuffer WebIDL type: {@link PxBroadPhaseRegionInfo}
     * @param bufferSize WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int getBroadPhaseRegions(PxBroadPhaseRegionInfo userBuffer, int bufferSize) {
        checkNotNull();
        return _getBroadPhaseRegions(address, userBuffer.getAddress(), bufferSize);
    }
    private static native int _getBroadPhaseRegions(long address, long userBuffer, int bufferSize);

    /**
     * @param userBuffer WebIDL type: {@link PxBroadPhaseRegionInfo}
     * @param bufferSize WebIDL type: unsigned long
     * @param startIndex WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int getBroadPhaseRegions(PxBroadPhaseRegionInfo userBuffer, int bufferSize, int startIndex) {
        checkNotNull();
        return _getBroadPhaseRegions(address, userBuffer.getAddress(), bufferSize, startIndex);
    }
    private static native int _getBroadPhaseRegions(long address, long userBuffer, int bufferSize, int startIndex);

    /**
     * @param region WebIDL type: {@link PxBroadPhaseRegion} [Const, Ref]
     * @return WebIDL type: unsigned long
     */
    public int addBroadPhaseRegion(PxBroadPhaseRegion region) {
        checkNotNull();
        return _addBroadPhaseRegion(address, region.getAddress());
    }
    private static native int _addBroadPhaseRegion(long address, long region);

    /**
     * @param region         WebIDL type: {@link PxBroadPhaseRegion} [Const, Ref]
     * @param populateRegion WebIDL type: boolean
     * @return WebIDL type: unsigned long
     */
    public int addBroadPhaseRegion(PxBroadPhaseRegion region, boolean populateRegion) {
        checkNotNull();
        return _addBroadPhaseRegion(address, region.getAddress(), populateRegion);
    }
    private static native int _addBroadPhaseRegion(long address, long region, boolean populateRegion);

    /**
     * @param handle WebIDL type: unsigned long
     * @return WebIDL type: boolean
     */
    public boolean removeBroadPhaseRegion(int handle) {
        checkNotNull();
        return _removeBroadPhaseRegion(address, handle);
    }
    private static native boolean _removeBroadPhaseRegion(long address, int handle);

    public void lockRead() {
        checkNotNull();
        _lockRead(address);
    }
    private static native void _lockRead(long address);

    /**
     * @param file WebIDL type: DOMString [Const]
     */
    public void lockRead(String file) {
        checkNotNull();
        _lockRead(address, file);
    }
    private static native void _lockRead(long address, String file);

    /**
     * @param file WebIDL type: DOMString [Const]
     * @param line WebIDL type: unsigned long
     */
    public void lockRead(String file, int line) {
        checkNotNull();
        _lockRead(address, file, line);
    }
    private static native void _lockRead(long address, String file, int line);

    public void unlockRead() {
        checkNotNull();
        _unlockRead(address);
    }
    private static native void _unlockRead(long address);

    public void lockWrite() {
        checkNotNull();
        _lockWrite(address);
    }
    private static native void _lockWrite(long address);

    /**
     * @param file WebIDL type: DOMString [Const]
     */
    public void lockWrite(String file) {
        checkNotNull();
        _lockWrite(address, file);
    }
    private static native void _lockWrite(long address, String file);

    /**
     * @param file WebIDL type: DOMString [Const]
     * @param line WebIDL type: unsigned long
     */
    public void lockWrite(String file, int line) {
        checkNotNull();
        _lockWrite(address, file, line);
    }
    private static native void _lockWrite(long address, String file, int line);

    public void unlockWrite() {
        checkNotNull();
        _unlockWrite(address);
    }
    private static native void _unlockWrite(long address);

    /**
     * @param numBlocks WebIDL type: unsigned long
     */
    public void setNbContactDataBlocks(int numBlocks) {
        checkNotNull();
        _setNbContactDataBlocks(address, numBlocks);
    }
    private static native void _setNbContactDataBlocks(long address, int numBlocks);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbContactDataBlocksUsed() {
        checkNotNull();
        return _getNbContactDataBlocksUsed(address);
    }
    private static native int _getNbContactDataBlocksUsed(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbContactDataBlocksUsed() {
        checkNotNull();
        return _getMaxNbContactDataBlocksUsed(address);
    }
    private static native int _getMaxNbContactDataBlocksUsed(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getContactReportStreamBufferSize() {
        checkNotNull();
        return _getContactReportStreamBufferSize(address);
    }
    private static native int _getContactReportStreamBufferSize(long address);

    /**
     * @param solverBatchSize WebIDL type: unsigned long
     */
    public void setSolverBatchSize(int solverBatchSize) {
        checkNotNull();
        _setSolverBatchSize(address, solverBatchSize);
    }
    private static native void _setSolverBatchSize(long address, int solverBatchSize);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getSolverBatchSize() {
        checkNotNull();
        return _getSolverBatchSize(address);
    }
    private static native int _getSolverBatchSize(long address);

    /**
     * @param solverBatchSize WebIDL type: unsigned long
     */
    public void setSolverArticulationBatchSize(int solverBatchSize) {
        checkNotNull();
        _setSolverArticulationBatchSize(address, solverBatchSize);
    }
    private static native void _setSolverArticulationBatchSize(long address, int solverBatchSize);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getSolverArticulationBatchSize() {
        checkNotNull();
        return _getSolverArticulationBatchSize(address);
    }
    private static native int _getSolverArticulationBatchSize(long address);

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @param flag  WebIDL type: {@link PxSceneFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setFlag(PxSceneFlagEnum flag, boolean value) {
        checkNotNull();
        _setFlag(address, flag.value, value);
    }
    private static native void _setFlag(long address, int flag, boolean value);

    /**
     * @return WebIDL type: {@link PxSceneFlags} [Value]
     */
    public PxSceneFlags getFlags() {
        checkNotNull();
        return PxSceneFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param limits WebIDL type: {@link PxSceneLimits} [Const, Ref]
     */
    public void setLimits(PxSceneLimits limits) {
        checkNotNull();
        _setLimits(address, limits.getAddress());
    }
    private static native void _setLimits(long address, long limits);

    /**
     * @return WebIDL type: {@link PxSceneLimits} [Value]
     */
    public PxSceneLimits getLimits() {
        checkNotNull();
        return PxSceneLimits.wrapPointer(_getLimits(address));
    }
    private static native long _getLimits(long address);

    /**
     * @return WebIDL type: {@link PxPhysics} [Ref]
     */
    public PxPhysics getPhysics() {
        checkNotNull();
        return PxPhysics.wrapPointer(_getPhysics(address));
    }
    private static native long _getPhysics(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getTimestamp() {
        checkNotNull();
        return _getTimestamp(address);
    }
    private static native int _getTimestamp(long address);

}
