package physx.physics;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxBounds3;
import physx.common.PxCpuDispatcher;
import physx.common.PxCudaContextManager;
import physx.common.PxTolerancesScale;
import physx.common.PxVec3;
import physx.common.PxgDynamicsMemoryConfig;

public class PxSceneDesc extends NativeObject {

    protected PxSceneDesc() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxSceneDesc wrapPointer(long address) {
        return address != 0L ? new PxSceneDesc(address) : null;
    }
    
    public static PxSceneDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxSceneDesc(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param scale   WebIDL type: {@link PxTolerancesScale} [Const, Ref]
     * @return Stack allocated object of PxSceneDesc
     */
    public static PxSceneDesc createAt(long address, PxTolerancesScale scale) {
        __placement_new_PxSceneDesc(address, scale.getAddress());
        PxSceneDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param scale     WebIDL type: {@link PxTolerancesScale} [Const, Ref]
     * @return Stack allocated object of PxSceneDesc
     */
    public static <T> PxSceneDesc createAt(T allocator, Allocator<T> allocate, PxTolerancesScale scale) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxSceneDesc(address, scale.getAddress());
        PxSceneDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxSceneDesc(long address, long scale);

    // Constructors

    /**
     * @param scale WebIDL type: {@link PxTolerancesScale} [Const, Ref]
     */
    public PxSceneDesc(PxTolerancesScale scale) {
        address = _PxSceneDesc(scale.getAddress());
    }
    private static native long _PxSceneDesc(long scale);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getGravity() {
        checkNotNull();
        return PxVec3.wrapPointer(_getGravity(address));
    }
    private static native long _getGravity(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setGravity(PxVec3 value) {
        checkNotNull();
        _setGravity(address, value.getAddress());
    }
    private static native void _setGravity(long address, long value);

    /**
     * @return WebIDL type: {@link PxSimulationEventCallback}
     */
    public PxSimulationEventCallback getSimulationEventCallback() {
        checkNotNull();
        return PxSimulationEventCallback.wrapPointer(_getSimulationEventCallback(address));
    }
    private static native long _getSimulationEventCallback(long address);

    /**
     * @param value WebIDL type: {@link PxSimulationEventCallback}
     */
    public void setSimulationEventCallback(PxSimulationEventCallback value) {
        checkNotNull();
        _setSimulationEventCallback(address, value.getAddress());
    }
    private static native void _setSimulationEventCallback(long address, long value);

    /**
     * @return WebIDL type: VoidPtr [Const]
     */
    public NativeObject getFilterShaderData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getFilterShaderData(address));
    }
    private static native long _getFilterShaderData(long address);

    /**
     * @param value WebIDL type: VoidPtr [Const]
     */
    public void setFilterShaderData(NativeObject value) {
        checkNotNull();
        _setFilterShaderData(address, value.getAddress());
    }
    private static native void _setFilterShaderData(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getFilterShaderDataSize() {
        checkNotNull();
        return _getFilterShaderDataSize(address);
    }
    private static native int _getFilterShaderDataSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setFilterShaderDataSize(int value) {
        checkNotNull();
        _setFilterShaderDataSize(address, value);
    }
    private static native void _setFilterShaderDataSize(long address, int value);

    /**
     * @return WebIDL type: {@link PxSimulationFilterShader} [Value]
     */
    public PxSimulationFilterShader getFilterShader() {
        checkNotNull();
        return PxSimulationFilterShader.wrapPointer(_getFilterShader(address));
    }
    private static native long _getFilterShader(long address);

    /**
     * @param value WebIDL type: {@link PxSimulationFilterShader} [Value]
     */
    public void setFilterShader(PxSimulationFilterShader value) {
        checkNotNull();
        _setFilterShader(address, value.getAddress());
    }
    private static native void _setFilterShader(long address, long value);

    /**
     * @return WebIDL type: {@link PxPairFilteringModeEnum} [enum]
     */
    public PxPairFilteringModeEnum getKineKineFilteringMode() {
        checkNotNull();
        return PxPairFilteringModeEnum.forValue(_getKineKineFilteringMode(address));
    }
    private static native int _getKineKineFilteringMode(long address);

    /**
     * @param value WebIDL type: {@link PxPairFilteringModeEnum} [enum]
     */
    public void setKineKineFilteringMode(PxPairFilteringModeEnum value) {
        checkNotNull();
        _setKineKineFilteringMode(address, value.value);
    }
    private static native void _setKineKineFilteringMode(long address, int value);

    /**
     * @return WebIDL type: {@link PxPairFilteringModeEnum} [enum]
     */
    public PxPairFilteringModeEnum getStaticKineFilteringMode() {
        checkNotNull();
        return PxPairFilteringModeEnum.forValue(_getStaticKineFilteringMode(address));
    }
    private static native int _getStaticKineFilteringMode(long address);

    /**
     * @param value WebIDL type: {@link PxPairFilteringModeEnum} [enum]
     */
    public void setStaticKineFilteringMode(PxPairFilteringModeEnum value) {
        checkNotNull();
        _setStaticKineFilteringMode(address, value.value);
    }
    private static native void _setStaticKineFilteringMode(long address, int value);

    /**
     * @return WebIDL type: {@link PxBroadPhaseTypeEnum} [enum]
     */
    public PxBroadPhaseTypeEnum getBroadPhaseType() {
        checkNotNull();
        return PxBroadPhaseTypeEnum.forValue(_getBroadPhaseType(address));
    }
    private static native int _getBroadPhaseType(long address);

    /**
     * @param value WebIDL type: {@link PxBroadPhaseTypeEnum} [enum]
     */
    public void setBroadPhaseType(PxBroadPhaseTypeEnum value) {
        checkNotNull();
        _setBroadPhaseType(address, value.value);
    }
    private static native void _setBroadPhaseType(long address, int value);

    /**
     * @return WebIDL type: {@link PxSceneLimits} [Value]
     */
    public PxSceneLimits getLimits() {
        checkNotNull();
        return PxSceneLimits.wrapPointer(_getLimits(address));
    }
    private static native long _getLimits(long address);

    /**
     * @param value WebIDL type: {@link PxSceneLimits} [Value]
     */
    public void setLimits(PxSceneLimits value) {
        checkNotNull();
        _setLimits(address, value.getAddress());
    }
    private static native void _setLimits(long address, long value);

    /**
     * @return WebIDL type: {@link PxFrictionTypeEnum} [enum]
     */
    public PxFrictionTypeEnum getFrictionType() {
        checkNotNull();
        return PxFrictionTypeEnum.forValue(_getFrictionType(address));
    }
    private static native int _getFrictionType(long address);

    /**
     * @param value WebIDL type: {@link PxFrictionTypeEnum} [enum]
     */
    public void setFrictionType(PxFrictionTypeEnum value) {
        checkNotNull();
        _setFrictionType(address, value.value);
    }
    private static native void _setFrictionType(long address, int value);

    /**
     * @return WebIDL type: {@link PxSolverTypeEnum} [enum]
     */
    public PxSolverTypeEnum getSolverType() {
        checkNotNull();
        return PxSolverTypeEnum.forValue(_getSolverType(address));
    }
    private static native int _getSolverType(long address);

    /**
     * @param value WebIDL type: {@link PxSolverTypeEnum} [enum]
     */
    public void setSolverType(PxSolverTypeEnum value) {
        checkNotNull();
        _setSolverType(address, value.value);
    }
    private static native void _setSolverType(long address, int value);

    /**
     * @return WebIDL type: float
     */
    public float getBounceThresholdVelocity() {
        checkNotNull();
        return _getBounceThresholdVelocity(address);
    }
    private static native float _getBounceThresholdVelocity(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setBounceThresholdVelocity(float value) {
        checkNotNull();
        _setBounceThresholdVelocity(address, value);
    }
    private static native void _setBounceThresholdVelocity(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getFrictionOffsetThreshold() {
        checkNotNull();
        return _getFrictionOffsetThreshold(address);
    }
    private static native float _getFrictionOffsetThreshold(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setFrictionOffsetThreshold(float value) {
        checkNotNull();
        _setFrictionOffsetThreshold(address, value);
    }
    private static native void _setFrictionOffsetThreshold(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getFrictionCorrelationDistance() {
        checkNotNull();
        return _getFrictionCorrelationDistance(address);
    }
    private static native float _getFrictionCorrelationDistance(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setFrictionCorrelationDistance(float value) {
        checkNotNull();
        _setFrictionCorrelationDistance(address, value);
    }
    private static native void _setFrictionCorrelationDistance(long address, float value);

    /**
     * @return WebIDL type: {@link PxSceneFlags} [Value]
     */
    public PxSceneFlags getFlags() {
        checkNotNull();
        return PxSceneFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value WebIDL type: {@link PxSceneFlags} [Value]
     */
    public void setFlags(PxSceneFlags value) {
        checkNotNull();
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

    /**
     * @return WebIDL type: {@link PxCpuDispatcher}
     */
    public PxCpuDispatcher getCpuDispatcher() {
        checkNotNull();
        return PxCpuDispatcher.wrapPointer(_getCpuDispatcher(address));
    }
    private static native long _getCpuDispatcher(long address);

    /**
     * @param value WebIDL type: {@link PxCpuDispatcher}
     */
    public void setCpuDispatcher(PxCpuDispatcher value) {
        checkNotNull();
        _setCpuDispatcher(address, value.getAddress());
    }
    private static native void _setCpuDispatcher(long address, long value);

    /**
     * @return WebIDL type: {@link PxCudaContextManager} [Platforms=windows;linux]
     */
    public PxCudaContextManager getCudaContextManager() {
        checkNotNull();
        PlatformChecks.requirePlatform(3, "physx.physics.PxSceneDesc");
        return PxCudaContextManager.wrapPointer(_getCudaContextManager(address));
    }
    private static native long _getCudaContextManager(long address);

    /**
     * @param value WebIDL type: {@link PxCudaContextManager} [Platforms=windows;linux]
     */
    public void setCudaContextManager(PxCudaContextManager value) {
        checkNotNull();
        PlatformChecks.requirePlatform(3, "physx.physics.PxSceneDesc");
        _setCudaContextManager(address, value.getAddress());
    }
    private static native void _setCudaContextManager(long address, long value);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getUserData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getUserData(address));
    }
    private static native long _getUserData(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setUserData(NativeObject value) {
        checkNotNull();
        _setUserData(address, value.getAddress());
    }
    private static native void _setUserData(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getSolverBatchSize() {
        checkNotNull();
        return _getSolverBatchSize(address);
    }
    private static native int _getSolverBatchSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setSolverBatchSize(int value) {
        checkNotNull();
        _setSolverBatchSize(address, value);
    }
    private static native void _setSolverBatchSize(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getSolverArticulationBatchSize() {
        checkNotNull();
        return _getSolverArticulationBatchSize(address);
    }
    private static native int _getSolverArticulationBatchSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setSolverArticulationBatchSize(int value) {
        checkNotNull();
        _setSolverArticulationBatchSize(address, value);
    }
    private static native void _setSolverArticulationBatchSize(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbContactDataBlocks() {
        checkNotNull();
        return _getNbContactDataBlocks(address);
    }
    private static native int _getNbContactDataBlocks(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbContactDataBlocks(int value) {
        checkNotNull();
        _setNbContactDataBlocks(address, value);
    }
    private static native void _setNbContactDataBlocks(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbContactDataBlocks() {
        checkNotNull();
        return _getMaxNbContactDataBlocks(address);
    }
    private static native int _getMaxNbContactDataBlocks(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxNbContactDataBlocks(int value) {
        checkNotNull();
        _setMaxNbContactDataBlocks(address, value);
    }
    private static native void _setMaxNbContactDataBlocks(long address, int value);

    /**
     * @return WebIDL type: float
     */
    public float getMaxBiasCoefficient() {
        checkNotNull();
        return _getMaxBiasCoefficient(address);
    }
    private static native float _getMaxBiasCoefficient(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMaxBiasCoefficient(float value) {
        checkNotNull();
        _setMaxBiasCoefficient(address, value);
    }
    private static native void _setMaxBiasCoefficient(long address, float value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getContactReportStreamBufferSize() {
        checkNotNull();
        return _getContactReportStreamBufferSize(address);
    }
    private static native int _getContactReportStreamBufferSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setContactReportStreamBufferSize(int value) {
        checkNotNull();
        _setContactReportStreamBufferSize(address, value);
    }
    private static native void _setContactReportStreamBufferSize(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getCcdMaxPasses() {
        checkNotNull();
        return _getCcdMaxPasses(address);
    }
    private static native int _getCcdMaxPasses(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setCcdMaxPasses(int value) {
        checkNotNull();
        _setCcdMaxPasses(address, value);
    }
    private static native void _setCcdMaxPasses(long address, int value);

    /**
     * @return WebIDL type: float
     */
    public float getCcdThreshold() {
        checkNotNull();
        return _getCcdThreshold(address);
    }
    private static native float _getCcdThreshold(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setCcdThreshold(float value) {
        checkNotNull();
        _setCcdThreshold(address, value);
    }
    private static native void _setCcdThreshold(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getCcdMaxSeparation() {
        checkNotNull();
        return _getCcdMaxSeparation(address);
    }
    private static native float _getCcdMaxSeparation(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setCcdMaxSeparation(float value) {
        checkNotNull();
        _setCcdMaxSeparation(address, value);
    }
    private static native void _setCcdMaxSeparation(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getWakeCounterResetValue() {
        checkNotNull();
        return _getWakeCounterResetValue(address);
    }
    private static native float _getWakeCounterResetValue(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setWakeCounterResetValue(float value) {
        checkNotNull();
        _setWakeCounterResetValue(address, value);
    }
    private static native void _setWakeCounterResetValue(long address, float value);

    /**
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public PxBounds3 getSanityBounds() {
        checkNotNull();
        return PxBounds3.wrapPointer(_getSanityBounds(address));
    }
    private static native long _getSanityBounds(long address);

    /**
     * @param value WebIDL type: {@link PxBounds3} [Value]
     */
    public void setSanityBounds(PxBounds3 value) {
        checkNotNull();
        _setSanityBounds(address, value.getAddress());
    }
    private static native void _setSanityBounds(long address, long value);

    /**
     * @return WebIDL type: {@link PxgDynamicsMemoryConfig} [Platforms=windows;linux, Value]
     */
    public PxgDynamicsMemoryConfig getGpuDynamicsConfig() {
        checkNotNull();
        PlatformChecks.requirePlatform(3, "physx.physics.PxSceneDesc");
        return PxgDynamicsMemoryConfig.wrapPointer(_getGpuDynamicsConfig(address));
    }
    private static native long _getGpuDynamicsConfig(long address);

    /**
     * @param value WebIDL type: {@link PxgDynamicsMemoryConfig} [Platforms=windows;linux, Value]
     */
    public void setGpuDynamicsConfig(PxgDynamicsMemoryConfig value) {
        checkNotNull();
        PlatformChecks.requirePlatform(3, "physx.physics.PxSceneDesc");
        _setGpuDynamicsConfig(address, value.getAddress());
    }
    private static native void _setGpuDynamicsConfig(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getGpuMaxNumPartitions() {
        checkNotNull();
        return _getGpuMaxNumPartitions(address);
    }
    private static native int _getGpuMaxNumPartitions(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setGpuMaxNumPartitions(int value) {
        checkNotNull();
        _setGpuMaxNumPartitions(address, value);
    }
    private static native void _setGpuMaxNumPartitions(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getGpuMaxNumStaticPartitions() {
        checkNotNull();
        return _getGpuMaxNumStaticPartitions(address);
    }
    private static native int _getGpuMaxNumStaticPartitions(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setGpuMaxNumStaticPartitions(int value) {
        checkNotNull();
        _setGpuMaxNumStaticPartitions(address, value);
    }
    private static native void _setGpuMaxNumStaticPartitions(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getGpuComputeVersion() {
        checkNotNull();
        return _getGpuComputeVersion(address);
    }
    private static native int _getGpuComputeVersion(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setGpuComputeVersion(int value) {
        checkNotNull();
        _setGpuComputeVersion(address, value);
    }
    private static native void _setGpuComputeVersion(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getContactPairSlabSize() {
        checkNotNull();
        return _getContactPairSlabSize(address);
    }
    private static native int _getContactPairSlabSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setContactPairSlabSize(int value) {
        checkNotNull();
        _setContactPairSlabSize(address, value);
    }
    private static native void _setContactPairSlabSize(long address, int value);

    /**
     * @return WebIDL type: {@link PxPruningStructureTypeEnum} [enum]
     */
    public PxPruningStructureTypeEnum getStaticStructure() {
        checkNotNull();
        return PxPruningStructureTypeEnum.forValue(_getStaticStructure(address));
    }
    private static native int _getStaticStructure(long address);

    /**
     * @param value WebIDL type: {@link PxPruningStructureTypeEnum} [enum]
     */
    public void setStaticStructure(PxPruningStructureTypeEnum value) {
        checkNotNull();
        _setStaticStructure(address, value.value);
    }
    private static native void _setStaticStructure(long address, int value);

    /**
     * @return WebIDL type: {@link PxPruningStructureTypeEnum} [enum]
     */
    public PxPruningStructureTypeEnum getDynamicStructure() {
        checkNotNull();
        return PxPruningStructureTypeEnum.forValue(_getDynamicStructure(address));
    }
    private static native int _getDynamicStructure(long address);

    /**
     * @param value WebIDL type: {@link PxPruningStructureTypeEnum} [enum]
     */
    public void setDynamicStructure(PxPruningStructureTypeEnum value) {
        checkNotNull();
        _setDynamicStructure(address, value.value);
    }
    private static native void _setDynamicStructure(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getDynamicTreeRebuildRateHint() {
        checkNotNull();
        return _getDynamicTreeRebuildRateHint(address);
    }
    private static native int _getDynamicTreeRebuildRateHint(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setDynamicTreeRebuildRateHint(int value) {
        checkNotNull();
        _setDynamicTreeRebuildRateHint(address, value);
    }
    private static native void _setDynamicTreeRebuildRateHint(long address, int value);

    /**
     * @return WebIDL type: {@link PxDynamicTreeSecondaryPrunerEnum} [enum]
     */
    public PxDynamicTreeSecondaryPrunerEnum getDynamicTreeSecondaryPruner() {
        checkNotNull();
        return PxDynamicTreeSecondaryPrunerEnum.forValue(_getDynamicTreeSecondaryPruner(address));
    }
    private static native int _getDynamicTreeSecondaryPruner(long address);

    /**
     * @param value WebIDL type: {@link PxDynamicTreeSecondaryPrunerEnum} [enum]
     */
    public void setDynamicTreeSecondaryPruner(PxDynamicTreeSecondaryPrunerEnum value) {
        checkNotNull();
        _setDynamicTreeSecondaryPruner(address, value.value);
    }
    private static native void _setDynamicTreeSecondaryPruner(long address, int value);

    /**
     * @return WebIDL type: {@link PxBVHBuildStrategyEnum} [enum]
     */
    public PxBVHBuildStrategyEnum getStaticBVHBuildStrategy() {
        checkNotNull();
        return PxBVHBuildStrategyEnum.forValue(_getStaticBVHBuildStrategy(address));
    }
    private static native int _getStaticBVHBuildStrategy(long address);

    /**
     * @param value WebIDL type: {@link PxBVHBuildStrategyEnum} [enum]
     */
    public void setStaticBVHBuildStrategy(PxBVHBuildStrategyEnum value) {
        checkNotNull();
        _setStaticBVHBuildStrategy(address, value.value);
    }
    private static native void _setStaticBVHBuildStrategy(long address, int value);

    /**
     * @return WebIDL type: {@link PxBVHBuildStrategyEnum} [enum]
     */
    public PxBVHBuildStrategyEnum getDynamicBVHBuildStrategy() {
        checkNotNull();
        return PxBVHBuildStrategyEnum.forValue(_getDynamicBVHBuildStrategy(address));
    }
    private static native int _getDynamicBVHBuildStrategy(long address);

    /**
     * @param value WebIDL type: {@link PxBVHBuildStrategyEnum} [enum]
     */
    public void setDynamicBVHBuildStrategy(PxBVHBuildStrategyEnum value) {
        checkNotNull();
        _setDynamicBVHBuildStrategy(address, value.value);
    }
    private static native void _setDynamicBVHBuildStrategy(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getStaticNbObjectsPerNode() {
        checkNotNull();
        return _getStaticNbObjectsPerNode(address);
    }
    private static native int _getStaticNbObjectsPerNode(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setStaticNbObjectsPerNode(int value) {
        checkNotNull();
        _setStaticNbObjectsPerNode(address, value);
    }
    private static native void _setStaticNbObjectsPerNode(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getDynamicNbObjectsPerNode() {
        checkNotNull();
        return _getDynamicNbObjectsPerNode(address);
    }
    private static native int _getDynamicNbObjectsPerNode(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setDynamicNbObjectsPerNode(int value) {
        checkNotNull();
        _setDynamicNbObjectsPerNode(address, value);
    }
    private static native void _setDynamicNbObjectsPerNode(long address, int value);

    /**
     * @return WebIDL type: {@link PxSceneQueryUpdateModeEnum} [enum]
     */
    public PxSceneQueryUpdateModeEnum getSceneQueryUpdateMode() {
        checkNotNull();
        return PxSceneQueryUpdateModeEnum.forValue(_getSceneQueryUpdateMode(address));
    }
    private static native int _getSceneQueryUpdateMode(long address);

    /**
     * @param value WebIDL type: {@link PxSceneQueryUpdateModeEnum} [enum]
     */
    public void setSceneQueryUpdateMode(PxSceneQueryUpdateModeEnum value) {
        checkNotNull();
        _setSceneQueryUpdateMode(address, value.value);
    }
    private static native void _setSceneQueryUpdateMode(long address, int value);

    // Functions

    /**
     * @param scale WebIDL type: {@link PxTolerancesScale} [Const, Ref]
     */
    public void setToDefault(PxTolerancesScale scale) {
        checkNotNull();
        _setToDefault(address, scale.getAddress());
    }
    private static native void _setToDefault(long address, long scale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
