package physx.physics;

import physx.NativeObject;

public class PxSceneLimits extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxSceneLimits wrapPointer(long address) {
        return address != 0L ? new PxSceneLimits(address) : null;
    }
    
    public static PxSceneLimits arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxSceneLimits(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxSceneLimits
     */
    public static PxSceneLimits createAt(long address) {
        __placement_new_PxSceneLimits(address);
        PxSceneLimits createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxSceneLimits
     */
    public static <T> PxSceneLimits createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxSceneLimits(address);
        PxSceneLimits createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxSceneLimits(long address);

    // Constructors

    public PxSceneLimits() {
        address = _PxSceneLimits();
    }
    private static native long _PxSceneLimits();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbActors() {
        checkNotNull();
        return _getMaxNbActors(address);
    }
    private static native int _getMaxNbActors(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxNbActors(int value) {
        checkNotNull();
        _setMaxNbActors(address, value);
    }
    private static native void _setMaxNbActors(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbBodies() {
        checkNotNull();
        return _getMaxNbBodies(address);
    }
    private static native int _getMaxNbBodies(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxNbBodies(int value) {
        checkNotNull();
        _setMaxNbBodies(address, value);
    }
    private static native void _setMaxNbBodies(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbStaticShapes() {
        checkNotNull();
        return _getMaxNbStaticShapes(address);
    }
    private static native int _getMaxNbStaticShapes(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxNbStaticShapes(int value) {
        checkNotNull();
        _setMaxNbStaticShapes(address, value);
    }
    private static native void _setMaxNbStaticShapes(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbDynamicShapes() {
        checkNotNull();
        return _getMaxNbDynamicShapes(address);
    }
    private static native int _getMaxNbDynamicShapes(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxNbDynamicShapes(int value) {
        checkNotNull();
        _setMaxNbDynamicShapes(address, value);
    }
    private static native void _setMaxNbDynamicShapes(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbAggregates() {
        checkNotNull();
        return _getMaxNbAggregates(address);
    }
    private static native int _getMaxNbAggregates(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxNbAggregates(int value) {
        checkNotNull();
        _setMaxNbAggregates(address, value);
    }
    private static native void _setMaxNbAggregates(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbConstraints() {
        checkNotNull();
        return _getMaxNbConstraints(address);
    }
    private static native int _getMaxNbConstraints(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxNbConstraints(int value) {
        checkNotNull();
        _setMaxNbConstraints(address, value);
    }
    private static native void _setMaxNbConstraints(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbRegions() {
        checkNotNull();
        return _getMaxNbRegions(address);
    }
    private static native int _getMaxNbRegions(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxNbRegions(int value) {
        checkNotNull();
        _setMaxNbRegions(address, value);
    }
    private static native void _setMaxNbRegions(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbBroadPhaseOverlaps() {
        checkNotNull();
        return _getMaxNbBroadPhaseOverlaps(address);
    }
    private static native int _getMaxNbBroadPhaseOverlaps(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMaxNbBroadPhaseOverlaps(int value) {
        checkNotNull();
        _setMaxNbBroadPhaseOverlaps(address, value);
    }
    private static native void _setMaxNbBroadPhaseOverlaps(long address, int value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
