package physx.physics;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.geometry.PxGeometry;

public class PxSceneQuerySystemBase extends NativeObject {

    protected PxSceneQuerySystemBase() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxSceneQuerySystemBase wrapPointer(long address) {
        return address != 0L ? new PxSceneQuerySystemBase(address) : null;
    }
    
    public static PxSceneQuerySystemBase arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxSceneQuerySystemBase(long address) {
        super(address);
    }

    // Functions

    /**
     * @param dynamicTreeRebuildRateHint WebIDL type: unsigned long
     */
    public void setDynamicTreeRebuildRateHint(int dynamicTreeRebuildRateHint) {
        checkNotNull();
        _setDynamicTreeRebuildRateHint(address, dynamicTreeRebuildRateHint);
    }
    private static native void _setDynamicTreeRebuildRateHint(long address, int dynamicTreeRebuildRateHint);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getDynamicTreeRebuildRateHint() {
        checkNotNull();
        return _getDynamicTreeRebuildRateHint(address);
    }
    private static native int _getDynamicTreeRebuildRateHint(long address);

    /**
     * @param prunerIndex WebIDL type: unsigned long
     */
    public void forceRebuildDynamicTree(int prunerIndex) {
        checkNotNull();
        _forceRebuildDynamicTree(address, prunerIndex);
    }
    private static native void _forceRebuildDynamicTree(long address, int prunerIndex);

    /**
     * @param updateMode WebIDL type: {@link PxSceneQueryUpdateModeEnum} [enum]
     */
    public void setUpdateMode(PxSceneQueryUpdateModeEnum updateMode) {
        checkNotNull();
        _setUpdateMode(address, updateMode.value);
    }
    private static native void _setUpdateMode(long address, int updateMode);

    /**
     * @return WebIDL type: {@link PxSceneQueryUpdateModeEnum} [enum]
     */
    public PxSceneQueryUpdateModeEnum getUpdateMode() {
        checkNotNull();
        return PxSceneQueryUpdateModeEnum.forValue(_getUpdateMode(address));
    }
    private static native int _getUpdateMode(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getStaticTimestamp() {
        checkNotNull();
        return _getStaticTimestamp(address);
    }
    private static native int _getStaticTimestamp(long address);

    public void flushUpdates() {
        checkNotNull();
        _flushUpdates(address);
    }
    private static native void _flushUpdates(long address);

    /**
     * @param origin   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param unitDir  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance WebIDL type: float
     * @param hitCall  WebIDL type: {@link PxRaycastCallback} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean raycast(PxVec3 origin, PxVec3 unitDir, float distance, PxRaycastCallback hitCall) {
        checkNotNull();
        return _raycast(address, origin.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress());
    }
    private static native boolean _raycast(long address, long origin, long unitDir, float distance, long hitCall);

    /**
     * @param origin   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param unitDir  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance WebIDL type: float
     * @param hitCall  WebIDL type: {@link PxRaycastCallback} [Ref]
     * @param hitFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean raycast(PxVec3 origin, PxVec3 unitDir, float distance, PxRaycastCallback hitCall, PxHitFlags hitFlags) {
        checkNotNull();
        return _raycast(address, origin.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress(), hitFlags.getAddress());
    }
    private static native boolean _raycast(long address, long origin, long unitDir, float distance, long hitCall, long hitFlags);

    /**
     * @param origin     WebIDL type: {@link PxVec3} [Const, Ref]
     * @param unitDir    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance   WebIDL type: float
     * @param hitCall    WebIDL type: {@link PxRaycastCallback} [Ref]
     * @param hitFlags   WebIDL type: {@link PxHitFlags} [Ref]
     * @param filterData WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean raycast(PxVec3 origin, PxVec3 unitDir, float distance, PxRaycastCallback hitCall, PxHitFlags hitFlags, PxQueryFilterData filterData) {
        checkNotNull();
        return _raycast(address, origin.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress(), hitFlags.getAddress(), filterData.getAddress());
    }
    private static native boolean _raycast(long address, long origin, long unitDir, float distance, long hitCall, long hitFlags, long filterData);

    /**
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param unitDir  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance WebIDL type: float
     * @param hitCall  WebIDL type: {@link PxSweepCallback} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean sweep(PxGeometry geometry, PxTransform pose, PxVec3 unitDir, float distance, PxSweepCallback hitCall) {
        checkNotNull();
        return _sweep(address, geometry.getAddress(), pose.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress());
    }
    private static native boolean _sweep(long address, long geometry, long pose, long unitDir, float distance, long hitCall);

    /**
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param unitDir  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance WebIDL type: float
     * @param hitCall  WebIDL type: {@link PxSweepCallback} [Ref]
     * @param hitFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean sweep(PxGeometry geometry, PxTransform pose, PxVec3 unitDir, float distance, PxSweepCallback hitCall, PxHitFlags hitFlags) {
        checkNotNull();
        return _sweep(address, geometry.getAddress(), pose.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress(), hitFlags.getAddress());
    }
    private static native boolean _sweep(long address, long geometry, long pose, long unitDir, float distance, long hitCall, long hitFlags);

    /**
     * @param geometry   WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose       WebIDL type: {@link PxTransform} [Const, Ref]
     * @param unitDir    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance   WebIDL type: float
     * @param hitCall    WebIDL type: {@link PxSweepCallback} [Ref]
     * @param hitFlags   WebIDL type: {@link PxHitFlags} [Ref]
     * @param filterData WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean sweep(PxGeometry geometry, PxTransform pose, PxVec3 unitDir, float distance, PxSweepCallback hitCall, PxHitFlags hitFlags, PxQueryFilterData filterData) {
        checkNotNull();
        return _sweep(address, geometry.getAddress(), pose.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress(), hitFlags.getAddress(), filterData.getAddress());
    }
    private static native boolean _sweep(long address, long geometry, long pose, long unitDir, float distance, long hitCall, long hitFlags, long filterData);

    /**
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param hitCall  WebIDL type: {@link PxOverlapCallback} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean overlap(PxGeometry geometry, PxTransform pose, PxOverlapCallback hitCall) {
        checkNotNull();
        return _overlap(address, geometry.getAddress(), pose.getAddress(), hitCall.getAddress());
    }
    private static native boolean _overlap(long address, long geometry, long pose, long hitCall);

    /**
     * @param geometry   WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose       WebIDL type: {@link PxTransform} [Const, Ref]
     * @param hitCall    WebIDL type: {@link PxOverlapCallback} [Ref]
     * @param filterData WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean overlap(PxGeometry geometry, PxTransform pose, PxOverlapCallback hitCall, PxQueryFilterData filterData) {
        checkNotNull();
        return _overlap(address, geometry.getAddress(), pose.getAddress(), hitCall.getAddress(), filterData.getAddress());
    }
    private static native boolean _overlap(long address, long geometry, long pose, long hitCall, long filterData);

}
