package physx.physics;

import physx.common.PxBaseTask;

public class PxSceneSQSystem extends PxSceneQuerySystemBase {

    protected PxSceneSQSystem() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxSceneSQSystem wrapPointer(long address) {
        return address != 0L ? new PxSceneSQSystem(address) : null;
    }
    
    public static PxSceneSQSystem arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxSceneSQSystem(long address) {
        super(address);
    }

    // Functions

    /**
     * @param updateMode WebIDL type: {@link PxSceneQueryUpdateModeEnum} [enum]
     */
    public void setSceneQueryUpdateMode(PxSceneQueryUpdateModeEnum updateMode) {
        checkNotNull();
        _setSceneQueryUpdateMode(address, updateMode.value);
    }
    private static native void _setSceneQueryUpdateMode(long address, int updateMode);

    /**
     * @return WebIDL type: {@link PxSceneQueryUpdateModeEnum} [enum]
     */
    public PxSceneQueryUpdateModeEnum getSceneQueryUpdateMode() {
        checkNotNull();
        return PxSceneQueryUpdateModeEnum.forValue(_getSceneQueryUpdateMode(address));
    }
    private static native int _getSceneQueryUpdateMode(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getSceneQueryStaticTimestamp() {
        checkNotNull();
        return _getSceneQueryStaticTimestamp(address);
    }
    private static native int _getSceneQueryStaticTimestamp(long address);

    public void flushQueryUpdates() {
        checkNotNull();
        _flushQueryUpdates(address);
    }
    private static native void _flushQueryUpdates(long address);

    /**
     * @param rebuildStaticStructure  WebIDL type: boolean
     * @param rebuildDynamicStructure WebIDL type: boolean
     */
    public void forceDynamicTreeRebuild(boolean rebuildStaticStructure, boolean rebuildDynamicStructure) {
        checkNotNull();
        _forceDynamicTreeRebuild(address, rebuildStaticStructure, rebuildDynamicStructure);
    }
    private static native void _forceDynamicTreeRebuild(long address, boolean rebuildStaticStructure, boolean rebuildDynamicStructure);

    /**
     * @return WebIDL type: {@link PxPruningStructureTypeEnum} [enum]
     */
    public PxPruningStructureTypeEnum getStaticStructure() {
        checkNotNull();
        return PxPruningStructureTypeEnum.forValue(_getStaticStructure(address));
    }
    private static native int _getStaticStructure(long address);

    /**
     * @return WebIDL type: {@link PxPruningStructureTypeEnum} [enum]
     */
    public PxPruningStructureTypeEnum getDynamicStructure() {
        checkNotNull();
        return PxPruningStructureTypeEnum.forValue(_getDynamicStructure(address));
    }
    private static native int _getDynamicStructure(long address);

    public void sceneQueriesUpdate() {
        checkNotNull();
        _sceneQueriesUpdate(address);
    }
    private static native void _sceneQueriesUpdate(long address);

    /**
     * @param completionTask WebIDL type: {@link PxBaseTask}
     */
    public void sceneQueriesUpdate(PxBaseTask completionTask) {
        checkNotNull();
        _sceneQueriesUpdate(address, completionTask.getAddress());
    }
    private static native void _sceneQueriesUpdate(long address, long completionTask);

    /**
     * @param completionTask    WebIDL type: {@link PxBaseTask}
     * @param controlSimulation WebIDL type: boolean
     */
    public void sceneQueriesUpdate(PxBaseTask completionTask, boolean controlSimulation) {
        checkNotNull();
        _sceneQueriesUpdate(address, completionTask.getAddress(), controlSimulation);
    }
    private static native void _sceneQueriesUpdate(long address, long completionTask, boolean controlSimulation);

    /**
     * @return WebIDL type: boolean
     */
    public boolean checkQueries() {
        checkNotNull();
        return _checkQueries(address);
    }
    private static native boolean _checkQueries(long address);

    /**
     * @param block WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public boolean checkQueries(boolean block) {
        checkNotNull();
        return _checkQueries(address, block);
    }
    private static native boolean _checkQueries(long address, boolean block);

    /**
     * @return WebIDL type: boolean
     */
    public boolean fetchQueries() {
        checkNotNull();
        return _fetchQueries(address);
    }
    private static native boolean _fetchQueries(long address);

    /**
     * @param block WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public boolean fetchQueries(boolean block) {
        checkNotNull();
        return _fetchQueries(address, block);
    }
    private static native boolean _fetchQueries(long address, boolean block);

}
