package physx.physics;

import physx.NativeObject;
import physx.common.PxRefCounted;
import physx.common.PxTransform;
import physx.geometry.PxGeometry;
import physx.support.PxMaterialPtr;

public class PxShape extends PxRefCounted {

    protected PxShape() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxShape wrapPointer(long address) {
        return address != 0L ? new PxShape(address) : null;
    }
    
    public static PxShape arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxShape(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getUserData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getUserData(address));
    }
    private static native long _getUserData(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setUserData(NativeObject value) {
        checkNotNull();
        _setUserData(address, value.getAddress());
    }
    private static native void _setUserData(long address, long value);

    // Functions

    /**
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     */
    public void setGeometry(PxGeometry geometry) {
        checkNotNull();
        _setGeometry(address, geometry.getAddress());
    }
    private static native void _setGeometry(long address, long geometry);

    /**
     * @return WebIDL type: {@link PxGeometry} [Const, Ref]
     */
    public PxGeometry getGeometry() {
        checkNotNull();
        return PxGeometry.wrapPointer(_getGeometry(address));
    }
    private static native long _getGeometry(long address);

    /**
     * @return WebIDL type: {@link PxRigidActor}
     */
    public PxRigidActor getActor() {
        checkNotNull();
        return PxRigidActor.wrapPointer(_getActor(address));
    }
    private static native long _getActor(long address);

    /**
     * @param materials     WebIDL type: {@link PxMaterialPtr}
     * @param materialCount WebIDL type: unsigned short
     */
    public void setMaterials(PxMaterialPtr materials, short materialCount) {
        checkNotNull();
        _setMaterials(address, materials.getAddress(), materialCount);
    }
    private static native void _setMaterials(long address, long materials, short materialCount);

    /**
     * @return WebIDL type: unsigned short
     */
    public short getNbMaterials() {
        checkNotNull();
        return _getNbMaterials(address);
    }
    private static native short _getNbMaterials(long address);

    /**
     * @param userBuffer WebIDL type: {@link PxMaterialPtr}
     * @param bufferSize WebIDL type: unsigned long
     * @param startIndex WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int getMaterials(PxMaterialPtr userBuffer, int bufferSize, int startIndex) {
        checkNotNull();
        return _getMaterials(address, userBuffer.getAddress(), bufferSize, startIndex);
    }
    private static native int _getMaterials(long address, long userBuffer, int bufferSize, int startIndex);

    /**
     * @param faceIndex WebIDL type: unsigned long
     * @return WebIDL type: {@link PxBaseMaterial}
     */
    public PxBaseMaterial getMaterialFromInternalFaceIndex(int faceIndex) {
        checkNotNull();
        return PxBaseMaterial.wrapPointer(_getMaterialFromInternalFaceIndex(address, faceIndex));
    }
    private static native long _getMaterialFromInternalFaceIndex(long address, int faceIndex);

    /**
     * @param contactOffset WebIDL type: float
     */
    public void setContactOffset(float contactOffset) {
        checkNotNull();
        _setContactOffset(address, contactOffset);
    }
    private static native void _setContactOffset(long address, float contactOffset);

    /**
     * @return WebIDL type: float
     */
    public float getContactOffset() {
        checkNotNull();
        return _getContactOffset(address);
    }
    private static native float _getContactOffset(long address);

    /**
     * @param restOffset WebIDL type: float
     */
    public void setRestOffset(float restOffset) {
        checkNotNull();
        _setRestOffset(address, restOffset);
    }
    private static native void _setRestOffset(long address, float restOffset);

    /**
     * @return WebIDL type: float
     */
    public float getRestOffset() {
        checkNotNull();
        return _getRestOffset(address);
    }
    private static native float _getRestOffset(long address);

    /**
     * @param radius WebIDL type: float
     */
    public void setTorsionalPatchRadius(float radius) {
        checkNotNull();
        _setTorsionalPatchRadius(address, radius);
    }
    private static native void _setTorsionalPatchRadius(long address, float radius);

    /**
     * @return WebIDL type: float
     */
    public float getTorsionalPatchRadius() {
        checkNotNull();
        return _getTorsionalPatchRadius(address);
    }
    private static native float _getTorsionalPatchRadius(long address);

    /**
     * @param radius WebIDL type: float
     */
    public void setMinTorsionalPatchRadius(float radius) {
        checkNotNull();
        _setMinTorsionalPatchRadius(address, radius);
    }
    private static native void _setMinTorsionalPatchRadius(long address, float radius);

    /**
     * @return WebIDL type: float
     */
    public float getMinTorsionalPatchRadius() {
        checkNotNull();
        return _getMinTorsionalPatchRadius(address);
    }
    private static native float _getMinTorsionalPatchRadius(long address);

    /**
     * @param flag  WebIDL type: {@link PxShapeFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setFlag(PxShapeFlagEnum flag, boolean value) {
        checkNotNull();
        _setFlag(address, flag.value, value);
    }
    private static native void _setFlag(long address, int flag, boolean value);

    /**
     * @param inFlags WebIDL type: {@link PxShapeFlags} [Ref]
     */
    public void setFlags(PxShapeFlags inFlags) {
        checkNotNull();
        _setFlags(address, inFlags.getAddress());
    }
    private static native void _setFlags(long address, long inFlags);

    /**
     * @return WebIDL type: {@link PxShapeFlags} [Value]
     */
    public PxShapeFlags getFlags() {
        checkNotNull();
        return PxShapeFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isExclusive() {
        checkNotNull();
        return _isExclusive(address);
    }
    private static native boolean _isExclusive(long address);

    /**
     * @param name WebIDL type: DOMString [Const]
     */
    public void setName(String name) {
        checkNotNull();
        _setName(address, name);
    }
    private static native void _setName(long address, String name);

    /**
     * @return WebIDL type: DOMString [Const]
     */
    public String getName() {
        checkNotNull();
        return _getName(address);
    }
    private static native String _getName(long address);

    /**
     * @param pose WebIDL type: {@link PxTransform} [Const, Ref]
     */
    public void setLocalPose(PxTransform pose) {
        checkNotNull();
        _setLocalPose(address, pose.getAddress());
    }
    private static native void _setLocalPose(long address, long pose);

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getLocalPose() {
        checkNotNull();
        return PxTransform.wrapPointer(_getLocalPose(address));
    }
    private static native long _getLocalPose(long address);

    /**
     * @param data WebIDL type: {@link PxFilterData} [Const, Ref]
     */
    public void setSimulationFilterData(PxFilterData data) {
        checkNotNull();
        _setSimulationFilterData(address, data.getAddress());
    }
    private static native void _setSimulationFilterData(long address, long data);

    /**
     * @return WebIDL type: {@link PxFilterData} [Value]
     */
    public PxFilterData getSimulationFilterData() {
        checkNotNull();
        return PxFilterData.wrapPointer(_getSimulationFilterData(address));
    }
    private static native long _getSimulationFilterData(long address);

    /**
     * @param data WebIDL type: {@link PxFilterData} [Const, Ref]
     */
    public void setQueryFilterData(PxFilterData data) {
        checkNotNull();
        _setQueryFilterData(address, data.getAddress());
    }
    private static native void _setQueryFilterData(long address, long data);

    /**
     * @return WebIDL type: {@link PxFilterData} [Value]
     */
    public PxFilterData getQueryFilterData() {
        checkNotNull();
        return PxFilterData.wrapPointer(_getQueryFilterData(address));
    }
    private static native long _getQueryFilterData(long address);

}
