package physx.physics;

import physx.NativeObject;
import physx.common.PxBounds3;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.geometry.PxGeometry;

public class PxShapeExt extends NativeObject {

    protected PxShapeExt() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxShapeExt wrapPointer(long address) {
        return address != 0L ? new PxShapeExt(address) : null;
    }
    
    public static PxShapeExt arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxShapeExt(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param shape WebIDL type: {@link PxShape} [Const, Ref]
     * @param actor WebIDL type: {@link PxRigidActor} [Const, Ref]
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public static PxTransform getGlobalPose(PxShape shape, PxRigidActor actor) {
        return PxTransform.wrapPointer(_getGlobalPose(shape.getAddress(), actor.getAddress()));
    }
    private static native long _getGlobalPose(long shape, long actor);

    /**
     * @param shape     WebIDL type: {@link PxShape} [Const, Ref]
     * @param actor     WebIDL type: {@link PxRigidActor} [Const, Ref]
     * @param rayOrigin WebIDL type: {@link PxVec3} [Const, Ref]
     * @param rayDir    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param maxDist   WebIDL type: float
     * @param hitFlags  WebIDL type: {@link PxHitFlags} [Ref]
     * @param maxHits   WebIDL type: unsigned long
     * @param rayHits   WebIDL type: {@link PxRaycastHit}
     * @return WebIDL type: unsigned long
     */
    public static int raycast(PxShape shape, PxRigidActor actor, PxVec3 rayOrigin, PxVec3 rayDir, float maxDist, PxHitFlags hitFlags, int maxHits, PxRaycastHit rayHits) {
        return _raycast(shape.getAddress(), actor.getAddress(), rayOrigin.getAddress(), rayDir.getAddress(), maxDist, hitFlags.getAddress(), maxHits, rayHits.getAddress());
    }
    private static native int _raycast(long shape, long actor, long rayOrigin, long rayDir, float maxDist, long hitFlags, int maxHits, long rayHits);

    /**
     * @param shape         WebIDL type: {@link PxShape} [Const, Ref]
     * @param actor         WebIDL type: {@link PxRigidActor} [Const, Ref]
     * @param otherGeom     WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param otherGeomPose WebIDL type: {@link PxTransform} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public static boolean overlap(PxShape shape, PxRigidActor actor, PxGeometry otherGeom, PxTransform otherGeomPose) {
        return _overlap(shape.getAddress(), actor.getAddress(), otherGeom.getAddress(), otherGeomPose.getAddress());
    }
    private static native boolean _overlap(long shape, long actor, long otherGeom, long otherGeomPose);

    /**
     * @param shape         WebIDL type: {@link PxShape} [Const, Ref]
     * @param actor         WebIDL type: {@link PxRigidActor} [Const, Ref]
     * @param unitDir       WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance      WebIDL type: float
     * @param otherGeom     WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param otherGeomPose WebIDL type: {@link PxTransform} [Const, Ref]
     * @param sweepHit      WebIDL type: {@link PxSweepHit} [Ref]
     * @param hitFlags      WebIDL type: {@link PxHitFlags} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean sweep(PxShape shape, PxRigidActor actor, PxVec3 unitDir, float distance, PxGeometry otherGeom, PxTransform otherGeomPose, PxSweepHit sweepHit, PxHitFlags hitFlags) {
        return _sweep(shape.getAddress(), actor.getAddress(), unitDir.getAddress(), distance, otherGeom.getAddress(), otherGeomPose.getAddress(), sweepHit.getAddress(), hitFlags.getAddress());
    }
    private static native boolean _sweep(long shape, long actor, long unitDir, float distance, long otherGeom, long otherGeomPose, long sweepHit, long hitFlags);

    /**
     * @param shape WebIDL type: {@link PxShape} [Const, Ref]
     * @param actor WebIDL type: {@link PxRigidActor} [Const, Ref]
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public static PxBounds3 getWorldBounds(PxShape shape, PxRigidActor actor) {
        return PxBounds3.wrapPointer(_getWorldBounds(shape.getAddress(), actor.getAddress()));
    }
    private static native long _getWorldBounds(long shape, long actor);

    /**
     * @param shape     WebIDL type: {@link PxShape} [Const, Ref]
     * @param actor     WebIDL type: {@link PxRigidActor} [Const, Ref]
     * @param inflation WebIDL type: float
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public static PxBounds3 getWorldBounds(PxShape shape, PxRigidActor actor, float inflation) {
        return PxBounds3.wrapPointer(_getWorldBounds(shape.getAddress(), actor.getAddress(), inflation));
    }
    private static native long _getWorldBounds(long shape, long actor, float inflation);

}
