package physx.physics;

import physx.NativeObject;

public class PxSimulationStatistics extends NativeObject {

    protected PxSimulationStatistics() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxSimulationStatistics wrapPointer(long address) {
        return address != 0L ? new PxSimulationStatistics(address) : null;
    }
    
    public static PxSimulationStatistics arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxSimulationStatistics(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbActiveConstraints() {
        checkNotNull();
        return _getNbActiveConstraints(address);
    }
    private static native int _getNbActiveConstraints(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbActiveConstraints(int value) {
        checkNotNull();
        _setNbActiveConstraints(address, value);
    }
    private static native void _setNbActiveConstraints(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbActiveDynamicBodies() {
        checkNotNull();
        return _getNbActiveDynamicBodies(address);
    }
    private static native int _getNbActiveDynamicBodies(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbActiveDynamicBodies(int value) {
        checkNotNull();
        _setNbActiveDynamicBodies(address, value);
    }
    private static native void _setNbActiveDynamicBodies(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbActiveKinematicBodies() {
        checkNotNull();
        return _getNbActiveKinematicBodies(address);
    }
    private static native int _getNbActiveKinematicBodies(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbActiveKinematicBodies(int value) {
        checkNotNull();
        _setNbActiveKinematicBodies(address, value);
    }
    private static native void _setNbActiveKinematicBodies(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbStaticBodies() {
        checkNotNull();
        return _getNbStaticBodies(address);
    }
    private static native int _getNbStaticBodies(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbStaticBodies(int value) {
        checkNotNull();
        _setNbStaticBodies(address, value);
    }
    private static native void _setNbStaticBodies(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbDynamicBodies() {
        checkNotNull();
        return _getNbDynamicBodies(address);
    }
    private static native int _getNbDynamicBodies(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbDynamicBodies(int value) {
        checkNotNull();
        _setNbDynamicBodies(address, value);
    }
    private static native void _setNbDynamicBodies(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbKinematicBodies() {
        checkNotNull();
        return _getNbKinematicBodies(address);
    }
    private static native int _getNbKinematicBodies(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbKinematicBodies(int value) {
        checkNotNull();
        _setNbKinematicBodies(address, value);
    }
    private static native void _setNbKinematicBodies(long address, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getNbShapes(int index) {
        checkNotNull();
        return _getNbShapes(address, index);
    }
    private static native int _getNbShapes(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setNbShapes(int index, int value) {
        checkNotNull();
        _setNbShapes(address, index, value);
    }
    private static native void _setNbShapes(long address, int index, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbAggregates() {
        checkNotNull();
        return _getNbAggregates(address);
    }
    private static native int _getNbAggregates(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbAggregates(int value) {
        checkNotNull();
        _setNbAggregates(address, value);
    }
    private static native void _setNbAggregates(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbArticulations() {
        checkNotNull();
        return _getNbArticulations(address);
    }
    private static native int _getNbArticulations(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbArticulations(int value) {
        checkNotNull();
        _setNbArticulations(address, value);
    }
    private static native void _setNbArticulations(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbAxisSolverConstraints() {
        checkNotNull();
        return _getNbAxisSolverConstraints(address);
    }
    private static native int _getNbAxisSolverConstraints(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbAxisSolverConstraints(int value) {
        checkNotNull();
        _setNbAxisSolverConstraints(address, value);
    }
    private static native void _setNbAxisSolverConstraints(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getCompressedContactSize() {
        checkNotNull();
        return _getCompressedContactSize(address);
    }
    private static native int _getCompressedContactSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setCompressedContactSize(int value) {
        checkNotNull();
        _setCompressedContactSize(address, value);
    }
    private static native void _setCompressedContactSize(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getRequiredContactConstraintMemory() {
        checkNotNull();
        return _getRequiredContactConstraintMemory(address);
    }
    private static native int _getRequiredContactConstraintMemory(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setRequiredContactConstraintMemory(int value) {
        checkNotNull();
        _setRequiredContactConstraintMemory(address, value);
    }
    private static native void _setRequiredContactConstraintMemory(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getPeakConstraintMemory() {
        checkNotNull();
        return _getPeakConstraintMemory(address);
    }
    private static native int _getPeakConstraintMemory(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setPeakConstraintMemory(int value) {
        checkNotNull();
        _setPeakConstraintMemory(address, value);
    }
    private static native void _setPeakConstraintMemory(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbDiscreteContactPairsTotal() {
        checkNotNull();
        return _getNbDiscreteContactPairsTotal(address);
    }
    private static native int _getNbDiscreteContactPairsTotal(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbDiscreteContactPairsTotal(int value) {
        checkNotNull();
        _setNbDiscreteContactPairsTotal(address, value);
    }
    private static native void _setNbDiscreteContactPairsTotal(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbDiscreteContactPairsWithCacheHits() {
        checkNotNull();
        return _getNbDiscreteContactPairsWithCacheHits(address);
    }
    private static native int _getNbDiscreteContactPairsWithCacheHits(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbDiscreteContactPairsWithCacheHits(int value) {
        checkNotNull();
        _setNbDiscreteContactPairsWithCacheHits(address, value);
    }
    private static native void _setNbDiscreteContactPairsWithCacheHits(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbDiscreteContactPairsWithContacts() {
        checkNotNull();
        return _getNbDiscreteContactPairsWithContacts(address);
    }
    private static native int _getNbDiscreteContactPairsWithContacts(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbDiscreteContactPairsWithContacts(int value) {
        checkNotNull();
        _setNbDiscreteContactPairsWithContacts(address, value);
    }
    private static native void _setNbDiscreteContactPairsWithContacts(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbNewPairs() {
        checkNotNull();
        return _getNbNewPairs(address);
    }
    private static native int _getNbNewPairs(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbNewPairs(int value) {
        checkNotNull();
        _setNbNewPairs(address, value);
    }
    private static native void _setNbNewPairs(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbLostPairs() {
        checkNotNull();
        return _getNbLostPairs(address);
    }
    private static native int _getNbLostPairs(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbLostPairs(int value) {
        checkNotNull();
        _setNbLostPairs(address, value);
    }
    private static native void _setNbLostPairs(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbNewTouches() {
        checkNotNull();
        return _getNbNewTouches(address);
    }
    private static native int _getNbNewTouches(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbNewTouches(int value) {
        checkNotNull();
        _setNbNewTouches(address, value);
    }
    private static native void _setNbNewTouches(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbLostTouches() {
        checkNotNull();
        return _getNbLostTouches(address);
    }
    private static native int _getNbLostTouches(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbLostTouches(int value) {
        checkNotNull();
        _setNbLostTouches(address, value);
    }
    private static native void _setNbLostTouches(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbPartitions() {
        checkNotNull();
        return _getNbPartitions(address);
    }
    private static native int _getNbPartitions(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbPartitions(int value) {
        checkNotNull();
        _setNbPartitions(address, value);
    }
    private static native void _setNbPartitions(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbBroadPhaseAdds() {
        checkNotNull();
        return _getNbBroadPhaseAdds(address);
    }
    private static native int _getNbBroadPhaseAdds(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbBroadPhaseAdds(int value) {
        checkNotNull();
        _setNbBroadPhaseAdds(address, value);
    }
    private static native void _setNbBroadPhaseAdds(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbBroadPhaseRemoves() {
        checkNotNull();
        return _getNbBroadPhaseRemoves(address);
    }
    private static native int _getNbBroadPhaseRemoves(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbBroadPhaseRemoves(int value) {
        checkNotNull();
        _setNbBroadPhaseRemoves(address, value);
    }
    private static native void _setNbBroadPhaseRemoves(long address, int value);

}
