package physx.physics;

public enum PxSolverTypeEnum {

    ePGS(getePGS()),
    eTGS(geteTGS());
    public final int value;
    
    PxSolverTypeEnum(int value) {
        this.value = value;
    }

    private static native int _getePGS();
    private static int getePGS() {
        de.fabmax.physxjni.Loader.load();
        return _getePGS();
    }

    private static native int _geteTGS();
    private static int geteTGS() {
        de.fabmax.physxjni.Loader.load();
        return _geteTGS();
    }

    public static PxSolverTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxSolverTypeEnum: " + value);
    }

}
