package physx.physics;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxSpatialVelocity extends NativeObject {

    protected PxSpatialVelocity() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxSpatialVelocity wrapPointer(long address) {
        return address != 0L ? new PxSpatialVelocity(address) : null;
    }
    
    public static PxSpatialVelocity arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxSpatialVelocity(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getLinear() {
        checkNotNull();
        return PxVec3.wrapPointer(_getLinear(address));
    }
    private static native long _getLinear(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setLinear(PxVec3 value) {
        checkNotNull();
        _setLinear(address, value.getAddress());
    }
    private static native void _setLinear(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getAngular() {
        checkNotNull();
        return PxVec3.wrapPointer(_getAngular(address));
    }
    private static native long _getAngular(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setAngular(PxVec3 value) {
        checkNotNull();
        _setAngular(address, value.getAddress());
    }
    private static native void _setAngular(long address, long value);

}
