package physx.physics;

import physx.NativeObject;

public class PxTriggerPair extends NativeObject {

    protected PxTriggerPair() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxTriggerPair wrapPointer(long address) {
        return address != 0L ? new PxTriggerPair(address) : null;
    }
    
    public static PxTriggerPair arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxTriggerPair(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxShape}
     */
    public PxShape getTriggerShape() {
        checkNotNull();
        return PxShape.wrapPointer(_getTriggerShape(address));
    }
    private static native long _getTriggerShape(long address);

    /**
     * @param value WebIDL type: {@link PxShape}
     */
    public void setTriggerShape(PxShape value) {
        checkNotNull();
        _setTriggerShape(address, value.getAddress());
    }
    private static native void _setTriggerShape(long address, long value);

    /**
     * @return WebIDL type: {@link PxActor}
     */
    public PxActor getTriggerActor() {
        checkNotNull();
        return PxActor.wrapPointer(_getTriggerActor(address));
    }
    private static native long _getTriggerActor(long address);

    /**
     * @param value WebIDL type: {@link PxActor}
     */
    public void setTriggerActor(PxActor value) {
        checkNotNull();
        _setTriggerActor(address, value.getAddress());
    }
    private static native void _setTriggerActor(long address, long value);

    /**
     * @return WebIDL type: {@link PxShape}
     */
    public PxShape getOtherShape() {
        checkNotNull();
        return PxShape.wrapPointer(_getOtherShape(address));
    }
    private static native long _getOtherShape(long address);

    /**
     * @param value WebIDL type: {@link PxShape}
     */
    public void setOtherShape(PxShape value) {
        checkNotNull();
        _setOtherShape(address, value.getAddress());
    }
    private static native void _setOtherShape(long address, long value);

    /**
     * @return WebIDL type: {@link PxActor}
     */
    public PxActor getOtherActor() {
        checkNotNull();
        return PxActor.wrapPointer(_getOtherActor(address));
    }
    private static native long _getOtherActor(long address);

    /**
     * @param value WebIDL type: {@link PxActor}
     */
    public void setOtherActor(PxActor value) {
        checkNotNull();
        _setOtherActor(address, value.getAddress());
    }
    private static native void _setOtherActor(long address, long value);

    /**
     * @return WebIDL type: {@link PxPairFlagEnum} [enum]
     */
    public PxPairFlagEnum getStatus() {
        checkNotNull();
        return PxPairFlagEnum.forValue(_getStatus(address));
    }
    private static native int _getStatus(long address);

    /**
     * @param value WebIDL type: {@link PxPairFlagEnum} [enum]
     */
    public void setStatus(PxPairFlagEnum value) {
        checkNotNull();
        _setStatus(address, value.value);
    }
    private static native void _setStatus(long address, int value);

    /**
     * @return WebIDL type: {@link PxTriggerPairFlags} [Value]
     */
    public PxTriggerPairFlags getFlags() {
        checkNotNull();
        return PxTriggerPairFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value WebIDL type: {@link PxTriggerPairFlags} [Value]
     */
    public void setFlags(PxTriggerPairFlags value) {
        checkNotNull();
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

}
