package physx.support;

import physx.NativeObject;

public class PxPvd extends NativeObject {

    protected PxPvd() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxPvd wrapPointer(long address) {
        return address != 0L ? new PxPvd(address) : null;
    }
    
    public static PxPvd arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxPvd(long address) {
        super(address);
    }

    // Functions

    /**
     * @param transport WebIDL type: {@link PxPvdTransport} [Ref]
     * @param flags     WebIDL type: {@link PxPvdInstrumentationFlags} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean connect(PxPvdTransport transport, PxPvdInstrumentationFlags flags) {
        checkNotNull();
        return _connect(address, transport.getAddress(), flags.getAddress());
    }
    private static native boolean _connect(long address, long transport, long flags);

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

}
