package physx.support;

import physx.NativeObject;

public class PxPvdTransport extends NativeObject {

    protected PxPvdTransport() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxPvdTransport wrapPointer(long address) {
        return address != 0L ? new PxPvdTransport(address) : null;
    }
    
    public static PxPvdTransport arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxPvdTransport(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean connect() {
        checkNotNull();
        return _connect(address);
    }
    private static native boolean _connect(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isConnected() {
        checkNotNull();
        return _isConnected(address);
    }
    private static native boolean _isConnected(long address);

    public void disconnect() {
        checkNotNull();
        _disconnect(address);
    }
    private static native void _disconnect(long address);

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

    public void flush() {
        checkNotNull();
        _flush(address);
    }
    private static native void _flush(long address);

}
