package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleAntiRollForceParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleAntiRollForceParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleAntiRollForceParams(address) : null;
    }
    
    public static PxVehicleAntiRollForceParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleAntiRollForceParams(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleAntiRollForceParams() {
        address = _PxVehicleAntiRollForceParams();
    }
    private static native long _PxVehicleAntiRollForceParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getWheel0() {
        checkNotNull();
        return _getWheel0(address);
    }
    private static native int _getWheel0(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setWheel0(int value) {
        checkNotNull();
        _setWheel0(address, value);
    }
    private static native void _setWheel0(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getWheel1() {
        checkNotNull();
        return _getWheel1(address);
    }
    private static native int _getWheel1(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setWheel1(int value) {
        checkNotNull();
        _setWheel1(address, value);
    }
    private static native void _setWheel1(long address, int value);

    /**
     * @return WebIDL type: float
     */
    public float getStiffness() {
        checkNotNull();
        return _getStiffness(address);
    }
    private static native float _getStiffness(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setStiffness(float value) {
        checkNotNull();
        _setStiffness(address, value);
    }
    private static native void _setStiffness(long address, float value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleAntiRollForceParams} [Value]
     */
    public PxVehicleAntiRollForceParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleAntiRollForceParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @param axleDesc WebIDL type: {@link PxVehicleAxleDescription} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean isValid(PxVehicleAxleDescription axleDesc) {
        checkNotNull();
        return _isValid(address, axleDesc.getAddress());
    }
    private static native boolean _isValid(long address, long axleDesc);

}
