package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxVehicleAntiRollTorque extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleAntiRollTorque wrapPointer(long address) {
        return address != 0L ? new PxVehicleAntiRollTorque(address) : null;
    }
    
    public static PxVehicleAntiRollTorque arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleAntiRollTorque(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleAntiRollTorque() {
        address = _PxVehicleAntiRollTorque();
    }
    private static native long _PxVehicleAntiRollTorque();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getAntiRollTorque() {
        checkNotNull();
        return PxVec3.wrapPointer(_getAntiRollTorque(address));
    }
    private static native long _getAntiRollTorque(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setAntiRollTorque(PxVec3 value) {
        checkNotNull();
        _setAntiRollTorque(address, value.getAddress());
    }
    private static native void _setAntiRollTorque(long address, long value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
