package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleAutoboxParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleAutoboxParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleAutoboxParams(address) : null;
    }
    
    public static PxVehicleAutoboxParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleAutoboxParams(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleAutoboxParams
     */
    public static PxVehicleAutoboxParams createAt(long address) {
        __placement_new_PxVehicleAutoboxParams(address);
        PxVehicleAutoboxParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleAutoboxParams
     */
    public static <T> PxVehicleAutoboxParams createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleAutoboxParams(address);
        PxVehicleAutoboxParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleAutoboxParams(long address);

    // Constructors

    public PxVehicleAutoboxParams() {
        address = _PxVehicleAutoboxParams();
    }
    private static native long _PxVehicleAutoboxParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getUpRatios(int index) {
        checkNotNull();
        return _getUpRatios(address, index);
    }
    private static native float _getUpRatios(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setUpRatios(int index, float value) {
        checkNotNull();
        _setUpRatios(address, index, value);
    }
    private static native void _setUpRatios(long address, int index, float value);

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getDownRatios(int index) {
        checkNotNull();
        return _getDownRatios(address, index);
    }
    private static native float _getDownRatios(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setDownRatios(int index, float value) {
        checkNotNull();
        _setDownRatios(address, index, value);
    }
    private static native void _setDownRatios(long address, int index, float value);

    /**
     * @return WebIDL type: float
     */
    public float getLatency() {
        checkNotNull();
        return _getLatency(address);
    }
    private static native float _getLatency(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setLatency(float value) {
        checkNotNull();
        _setLatency(address, value);
    }
    private static native void _setLatency(long address, float value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleAutoboxParams} [Value]
     */
    public PxVehicleAutoboxParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleAutoboxParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @param gearboxParams WebIDL type: {@link PxVehicleGearboxParams} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean isValid(PxVehicleGearboxParams gearboxParams) {
        checkNotNull();
        return _isValid(address, gearboxParams.getAddress());
    }
    private static native boolean _isValid(long address, long gearboxParams);

}
