package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleAxleDescription extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleAxleDescription wrapPointer(long address) {
        return address != 0L ? new PxVehicleAxleDescription(address) : null;
    }
    
    public static PxVehicleAxleDescription arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleAxleDescription(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleAxleDescription() {
        address = _PxVehicleAxleDescription();
    }
    private static native long _PxVehicleAxleDescription();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbAxles() {
        checkNotNull();
        return _getNbAxles(address);
    }
    private static native int _getNbAxles(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbAxles(int value) {
        checkNotNull();
        _setNbAxles(address, value);
    }
    private static native void _setNbAxles(long address, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelsPerAxle(int index) {
        checkNotNull();
        return _getNbWheelsPerAxle(address, index);
    }
    private static native int _getNbWheelsPerAxle(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setNbWheelsPerAxle(int index, int value) {
        checkNotNull();
        _setNbWheelsPerAxle(address, index, value);
    }
    private static native void _setNbWheelsPerAxle(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getAxleToWheelIds(int index) {
        checkNotNull();
        return _getAxleToWheelIds(address, index);
    }
    private static native int _getAxleToWheelIds(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setAxleToWheelIds(int index, int value) {
        checkNotNull();
        _setAxleToWheelIds(address, index, value);
    }
    private static native void _setAxleToWheelIds(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getWheelIdsInAxleOrder(int index) {
        checkNotNull();
        return _getWheelIdsInAxleOrder(address, index);
    }
    private static native int _getWheelIdsInAxleOrder(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setWheelIdsInAxleOrder(int index, int value) {
        checkNotNull();
        _setWheelIdsInAxleOrder(address, index, value);
    }
    private static native void _setWheelIdsInAxleOrder(long address, int index, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbWheels() {
        checkNotNull();
        return _getNbWheels(address);
    }
    private static native int _getNbWheels(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbWheels(int value) {
        checkNotNull();
        _setNbWheels(address, value);
    }
    private static native void _setNbWheels(long address, int value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @param i WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelsOnAxle(int i) {
        checkNotNull();
        return _getNbWheelsOnAxle(address, i);
    }
    private static native int _getNbWheelsOnAxle(long address, int i);

    /**
     * @param j WebIDL type: unsigned long
     * @param i WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int getWheelOnAxle(int j, int i) {
        checkNotNull();
        return _getWheelOnAxle(address, j, i);
    }
    private static native int _getWheelOnAxle(long address, int j, int i);

    /**
     * @param wheelId WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int getAxle(int wheelId) {
        checkNotNull();
        return _getAxle(address, wheelId);
    }
    private static native int _getAxle(long address, int wheelId);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
