package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleClutchParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleClutchParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleClutchParams(address) : null;
    }
    
    public static PxVehicleClutchParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleClutchParams(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleClutchParams
     */
    public static PxVehicleClutchParams createAt(long address) {
        __placement_new_PxVehicleClutchParams(address);
        PxVehicleClutchParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleClutchParams
     */
    public static <T> PxVehicleClutchParams createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleClutchParams(address);
        PxVehicleClutchParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleClutchParams(long address);

    // Constructors

    public PxVehicleClutchParams() {
        address = _PxVehicleClutchParams();
    }
    private static native long _PxVehicleClutchParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVehicleClutchAccuracyModeEnum} [enum]
     */
    public PxVehicleClutchAccuracyModeEnum getAccuracyMode() {
        checkNotNull();
        return PxVehicleClutchAccuracyModeEnum.forValue(_getAccuracyMode(address));
    }
    private static native int _getAccuracyMode(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleClutchAccuracyModeEnum} [enum]
     */
    public void setAccuracyMode(PxVehicleClutchAccuracyModeEnum value) {
        checkNotNull();
        _setAccuracyMode(address, value.value);
    }
    private static native void _setAccuracyMode(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getEstimateIterations() {
        checkNotNull();
        return _getEstimateIterations(address);
    }
    private static native int _getEstimateIterations(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setEstimateIterations(int value) {
        checkNotNull();
        _setEstimateIterations(address, value);
    }
    private static native void _setEstimateIterations(long address, int value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleClutchParams} [Value]
     */
    public PxVehicleClutchParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleClutchParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
