package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleClutchSlipState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleClutchSlipState wrapPointer(long address) {
        return address != 0L ? new PxVehicleClutchSlipState(address) : null;
    }
    
    public static PxVehicleClutchSlipState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleClutchSlipState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleClutchSlipState() {
        address = _PxVehicleClutchSlipState();
    }
    private static native long _PxVehicleClutchSlipState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getClutchSlip() {
        checkNotNull();
        return _getClutchSlip(address);
    }
    private static native float _getClutchSlip(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setClutchSlip(float value) {
        checkNotNull();
        _setClutchSlip(address, value);
    }
    private static native void _setClutchSlip(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
