package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleCommandNonLinearResponseParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleCommandNonLinearResponseParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleCommandNonLinearResponseParams(address) : null;
    }
    
    public static PxVehicleCommandNonLinearResponseParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleCommandNonLinearResponseParams(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleCommandNonLinearResponseParams() {
        address = _PxVehicleCommandNonLinearResponseParams();
    }
    private static native long _PxVehicleCommandNonLinearResponseParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getSpeedResponses(int index) {
        checkNotNull();
        return _getSpeedResponses(address, index);
    }
    private static native float _getSpeedResponses(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setSpeedResponses(int index, float value) {
        checkNotNull();
        _setSpeedResponses(address, index, value);
    }
    private static native void _setSpeedResponses(long address, int index, float value);

    /**
     * @return WebIDL type: short
     */
    public short getNbSpeedResponses() {
        checkNotNull();
        return _getNbSpeedResponses(address);
    }
    private static native short _getNbSpeedResponses(long address);

    /**
     * @param value WebIDL type: short
     */
    public void setNbSpeedResponses(short value) {
        checkNotNull();
        _setNbSpeedResponses(address, value);
    }
    private static native void _setNbSpeedResponses(long address, short value);

    /**
     * @param index Array index
     * @return WebIDL type: short
     */
    public short getSpeedResponsesPerCommandValue(int index) {
        checkNotNull();
        return _getSpeedResponsesPerCommandValue(address, index);
    }
    private static native short _getSpeedResponsesPerCommandValue(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: short
     */
    public void setSpeedResponsesPerCommandValue(int index, short value) {
        checkNotNull();
        _setSpeedResponsesPerCommandValue(address, index, value);
    }
    private static native void _setSpeedResponsesPerCommandValue(long address, int index, short value);

    /**
     * @param index Array index
     * @return WebIDL type: short
     */
    public short getNbSpeedResponsesPerCommandValue(int index) {
        checkNotNull();
        return _getNbSpeedResponsesPerCommandValue(address, index);
    }
    private static native short _getNbSpeedResponsesPerCommandValue(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: short
     */
    public void setNbSpeedResponsesPerCommandValue(int index, short value) {
        checkNotNull();
        _setNbSpeedResponsesPerCommandValue(address, index, value);
    }
    private static native void _setNbSpeedResponsesPerCommandValue(long address, int index, short value);

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getCommandValues(int index) {
        checkNotNull();
        return _getCommandValues(address, index);
    }
    private static native float _getCommandValues(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setCommandValues(int index, float value) {
        checkNotNull();
        _setCommandValues(address, index, value);
    }
    private static native void _setCommandValues(long address, int index, float value);

    /**
     * @return WebIDL type: short
     */
    public short getNbCommandValues() {
        checkNotNull();
        return _getNbCommandValues(address);
    }
    private static native short _getNbCommandValues(long address);

    /**
     * @param value WebIDL type: short
     */
    public void setNbCommandValues(short value) {
        checkNotNull();
        _setNbCommandValues(address, value);
    }
    private static native void _setNbCommandValues(long address, short value);

    // Functions

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

    /**
     * @param commandValueSpeedResponses WebIDL type: {@link PxVehicleCommandValueResponseTable} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean addResponse(PxVehicleCommandValueResponseTable commandValueSpeedResponses) {
        checkNotNull();
        return _addResponse(address, commandValueSpeedResponses.getAddress());
    }
    private static native boolean _addResponse(long address, long commandValueSpeedResponses);

}
