package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleCommandResponseParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleCommandResponseParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleCommandResponseParams(address) : null;
    }
    
    public static PxVehicleCommandResponseParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleCommandResponseParams(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleCommandResponseParams() {
        address = _PxVehicleCommandResponseParams();
    }
    private static native long _PxVehicleCommandResponseParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVehicleCommandNonLinearResponseParams} [Value]
     */
    public PxVehicleCommandNonLinearResponseParams getNonlinearResponse() {
        checkNotNull();
        return PxVehicleCommandNonLinearResponseParams.wrapPointer(_getNonlinearResponse(address));
    }
    private static native long _getNonlinearResponse(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleCommandNonLinearResponseParams} [Value]
     */
    public void setNonlinearResponse(PxVehicleCommandNonLinearResponseParams value) {
        checkNotNull();
        _setNonlinearResponse(address, value.getAddress());
    }
    private static native void _setNonlinearResponse(long address, long value);

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getWheelResponseMultipliers(int index) {
        checkNotNull();
        return _getWheelResponseMultipliers(address, index);
    }
    private static native float _getWheelResponseMultipliers(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setWheelResponseMultipliers(int index, float value) {
        checkNotNull();
        _setWheelResponseMultipliers(address, index, value);
    }
    private static native void _setWheelResponseMultipliers(long address, int index, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMaxResponse() {
        checkNotNull();
        return _getMaxResponse(address);
    }
    private static native float _getMaxResponse(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMaxResponse(float value) {
        checkNotNull();
        _setMaxResponse(address, value);
    }
    private static native void _setMaxResponse(long address, float value);

}
