package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleCommandValueResponseTable extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleCommandValueResponseTable wrapPointer(long address) {
        return address != 0L ? new PxVehicleCommandValueResponseTable(address) : null;
    }
    
    public static PxVehicleCommandValueResponseTable arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleCommandValueResponseTable(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleCommandValueResponseTable() {
        address = _PxVehicleCommandValueResponseTable();
    }
    private static native long _PxVehicleCommandValueResponseTable();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getCommandValue() {
        checkNotNull();
        return _getCommandValue(address);
    }
    private static native float _getCommandValue(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setCommandValue(float value) {
        checkNotNull();
        _setCommandValue(address, value);
    }
    private static native void _setCommandValue(long address, float value);

}
