package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleEngineDriveThrottleCommandResponseState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleEngineDriveThrottleCommandResponseState wrapPointer(long address) {
        return address != 0L ? new PxVehicleEngineDriveThrottleCommandResponseState(address) : null;
    }
    
    public static PxVehicleEngineDriveThrottleCommandResponseState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleEngineDriveThrottleCommandResponseState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleEngineDriveThrottleCommandResponseState() {
        address = _PxVehicleEngineDriveThrottleCommandResponseState();
    }
    private static native long _PxVehicleEngineDriveThrottleCommandResponseState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getCommandResponse() {
        checkNotNull();
        return _getCommandResponse(address);
    }
    private static native float _getCommandResponse(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setCommandResponse(float value) {
        checkNotNull();
        _setCommandResponse(address, value);
    }
    private static native void _setCommandResponse(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
