package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleEngineState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleEngineState wrapPointer(long address) {
        return address != 0L ? new PxVehicleEngineState(address) : null;
    }
    
    public static PxVehicleEngineState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleEngineState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleEngineState() {
        address = _PxVehicleEngineState();
    }
    private static native long _PxVehicleEngineState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getRotationSpeed() {
        checkNotNull();
        return _getRotationSpeed(address);
    }
    private static native float _getRotationSpeed(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setRotationSpeed(float value) {
        checkNotNull();
        _setRotationSpeed(address, value);
    }
    private static native void _setRotationSpeed(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
